/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachObjectRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<DetachObjectRequest.Builder, DetachObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(DetachObjectRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ParentReference")
            .getter(getter(DetachObjectRequest::parentReference)).setter(setter(Builder::parentReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(DetachObjectRequest::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            PARENT_REFERENCE_FIELD, LINK_NAME_FIELD));

    private final String directoryArn;

    private final ObjectReference parentReference;

    private final String linkName;

    private DetachObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For more
     * information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For
     *         more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The parent reference from which the object with the specified link name is detached.
     * </p>
     * 
     * @return The parent reference from which the object with the specified link name is detached.
     */
    public final ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The link name associated with the object that needs to be detached.
     * </p>
     * 
     * @return The link name associated with the object that needs to be detached.
     */
    public final String linkName() {
        return linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachObjectRequest)) {
            return false;
        }
        DetachObjectRequest other = (DetachObjectRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(parentReference(), other.parentReference())
                && Objects.equals(linkName(), other.linkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachObjectRequest").add("DirectoryArn", directoryArn())
                .add("ParentReference", parentReference()).add("LinkName", linkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachObjectRequest, T> g) {
        return obj -> g.apply((DetachObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachObjectRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For more
         * information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For
         *        more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The parent reference from which the object with the specified link name is detached.
         * </p>
         * 
         * @param parentReference
         *        The parent reference from which the object with the specified link name is detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * The parent reference from which the object with the specified link name is detached.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The link name associated with the object that needs to be detached.
         * </p>
         * 
         * @param linkName
         *        The link name associated with the object that needs to be detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference parentReference;

        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachObjectRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            parentReference(model.parentReference);
            linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final String getLinkName() {
            return linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachObjectRequest build() {
            return new DetachObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
