/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachTypedLinkRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<DetachTypedLinkRequest.Builder, DetachTypedLinkRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(DetachTypedLinkRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<TypedLinkSpecifier> TYPED_LINK_SPECIFIER_FIELD = SdkField
            .<TypedLinkSpecifier> builder(MarshallingType.SDK_POJO).memberName("TypedLinkSpecifier")
            .getter(getter(DetachTypedLinkRequest::typedLinkSpecifier)).setter(setter(Builder::typedLinkSpecifier))
            .constructor(TypedLinkSpecifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            TYPED_LINK_SPECIFIER_FIELD));

    private final String directoryArn;

    private final TypedLinkSpecifier typedLinkSpecifier;

    private DetachTypedLinkRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Used to accept a typed link specifier as input.
     * </p>
     * 
     * @return Used to accept a typed link specifier as input.
     */
    public final TypedLinkSpecifier typedLinkSpecifier() {
        return typedLinkSpecifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkSpecifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachTypedLinkRequest)) {
            return false;
        }
        DetachTypedLinkRequest other = (DetachTypedLinkRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn())
                && Objects.equals(typedLinkSpecifier(), other.typedLinkSpecifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachTypedLinkRequest").add("DirectoryArn", directoryArn())
                .add("TypedLinkSpecifier", typedLinkSpecifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "TypedLinkSpecifier":
            return Optional.ofNullable(clazz.cast(typedLinkSpecifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachTypedLinkRequest, T> g) {
        return obj -> g.apply((DetachTypedLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachTypedLinkRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Used to accept a typed link specifier as input.
         * </p>
         * 
         * @param typedLinkSpecifier
         *        Used to accept a typed link specifier as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier);

        /**
         * <p>
         * Used to accept a typed link specifier as input.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedLinkSpecifier.Builder} avoiding the
         * need to create one manually via {@link TypedLinkSpecifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSpecifier.Builder#build()} is called immediately and its
         * result is passed to {@link #typedLinkSpecifier(TypedLinkSpecifier)}.
         * 
         * @param typedLinkSpecifier
         *        a consumer that will call methods on {@link TypedLinkSpecifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typedLinkSpecifier(TypedLinkSpecifier)
         */
        default Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return typedLinkSpecifier(TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private TypedLinkSpecifier typedLinkSpecifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachTypedLinkRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            typedLinkSpecifier(model.typedLinkSpecifier);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return typedLinkSpecifier != null ? typedLinkSpecifier.toBuilder() : null;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachTypedLinkRequest build() {
            return new DetachTypedLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
