/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute that is associated with the <a>Facet</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FacetAttribute implements SdkPojo, Serializable, ToCopyableBuilder<FacetAttribute.Builder, FacetAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FacetAttribute::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<FacetAttributeDefinition> ATTRIBUTE_DEFINITION_FIELD = SdkField
            .<FacetAttributeDefinition> builder(MarshallingType.SDK_POJO).memberName("AttributeDefinition")
            .getter(getter(FacetAttribute::attributeDefinition)).setter(setter(Builder::attributeDefinition))
            .constructor(FacetAttributeDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinition").build())
            .build();

    private static final SdkField<FacetAttributeReference> ATTRIBUTE_REFERENCE_FIELD = SdkField
            .<FacetAttributeReference> builder(MarshallingType.SDK_POJO).memberName("AttributeReference")
            .getter(getter(FacetAttribute::attributeReference)).setter(setter(Builder::attributeReference))
            .constructor(FacetAttributeReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeReference").build())
            .build();

    private static final SdkField<String> REQUIRED_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequiredBehavior").getter(getter(FacetAttribute::requiredBehaviorAsString))
            .setter(setter(Builder::requiredBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ATTRIBUTE_DEFINITION_FIELD, ATTRIBUTE_REFERENCE_FIELD, REQUIRED_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final FacetAttributeDefinition attributeDefinition;

    private final FacetAttributeReference attributeReference;

    private final String requiredBehavior;

    private FacetAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.attributeDefinition = builder.attributeDefinition;
        this.attributeReference = builder.attributeReference;
        this.requiredBehavior = builder.requiredBehavior;
    }

    /**
     * <p>
     * The name of the facet attribute.
     * </p>
     * 
     * @return The name of the facet attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A facet attribute consists of either a definition or a reference. This structure contains the attribute
     * definition. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     * >Attribute References</a> for more information.
     * </p>
     * 
     * @return A facet attribute consists of either a definition or a reference. This structure contains the attribute
     *         definition. See <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     *         >Attribute References</a> for more information.
     */
    public final FacetAttributeDefinition attributeDefinition() {
        return attributeDefinition;
    }

    /**
     * <p>
     * An attribute reference that is associated with the attribute. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     * >Attribute References</a> for more information.
     * </p>
     * 
     * @return An attribute reference that is associated with the attribute. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     *         >Attribute References</a> for more information.
     */
    public final FacetAttributeReference attributeReference() {
        return attributeReference;
    }

    /**
     * <p>
     * The required behavior of the <code>FacetAttribute</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requiredBehavior}
     * will return {@link RequiredAttributeBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #requiredBehaviorAsString}.
     * </p>
     * 
     * @return The required behavior of the <code>FacetAttribute</code>.
     * @see RequiredAttributeBehavior
     */
    public final RequiredAttributeBehavior requiredBehavior() {
        return RequiredAttributeBehavior.fromValue(requiredBehavior);
    }

    /**
     * <p>
     * The required behavior of the <code>FacetAttribute</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requiredBehavior}
     * will return {@link RequiredAttributeBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #requiredBehaviorAsString}.
     * </p>
     * 
     * @return The required behavior of the <code>FacetAttribute</code>.
     * @see RequiredAttributeBehavior
     */
    public final String requiredBehaviorAsString() {
        return requiredBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attributeDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(attributeReference());
        hashCode = 31 * hashCode + Objects.hashCode(requiredBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttribute)) {
            return false;
        }
        FacetAttribute other = (FacetAttribute) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(attributeDefinition(), other.attributeDefinition())
                && Objects.equals(attributeReference(), other.attributeReference())
                && Objects.equals(requiredBehaviorAsString(), other.requiredBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FacetAttribute").add("Name", name()).add("AttributeDefinition", attributeDefinition())
                .add("AttributeReference", attributeReference()).add("RequiredBehavior", requiredBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AttributeDefinition":
            return Optional.ofNullable(clazz.cast(attributeDefinition()));
        case "AttributeReference":
            return Optional.ofNullable(clazz.cast(attributeReference()));
        case "RequiredBehavior":
            return Optional.ofNullable(clazz.cast(requiredBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetAttribute, T> g) {
        return obj -> g.apply((FacetAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FacetAttribute> {
        /**
         * <p>
         * The name of the facet attribute.
         * </p>
         * 
         * @param name
         *        The name of the facet attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A facet attribute consists of either a definition or a reference. This structure contains the attribute
         * definition. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         * >Attribute References</a> for more information.
         * </p>
         * 
         * @param attributeDefinition
         *        A facet attribute consists of either a definition or a reference. This structure contains the
         *        attribute definition. See <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         *        >Attribute References</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinition(FacetAttributeDefinition attributeDefinition);

        /**
         * <p>
         * A facet attribute consists of either a definition or a reference. This structure contains the attribute
         * definition. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         * >Attribute References</a> for more information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FacetAttributeDefinition.Builder}
         * avoiding the need to create one manually via {@link FacetAttributeDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link FacetAttributeDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeDefinition(FacetAttributeDefinition)}.
         * 
         * @param attributeDefinition
         *        a consumer that will call methods on {@link FacetAttributeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinition(FacetAttributeDefinition)
         */
        default Builder attributeDefinition(Consumer<FacetAttributeDefinition.Builder> attributeDefinition) {
            return attributeDefinition(FacetAttributeDefinition.builder().applyMutation(attributeDefinition).build());
        }

        /**
         * <p>
         * An attribute reference that is associated with the attribute. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         * >Attribute References</a> for more information.
         * </p>
         * 
         * @param attributeReference
         *        An attribute reference that is associated with the attribute. See <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         *        >Attribute References</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeReference(FacetAttributeReference attributeReference);

        /**
         * <p>
         * An attribute reference that is associated with the attribute. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         * >Attribute References</a> for more information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FacetAttributeReference.Builder} avoiding
         * the need to create one manually via {@link FacetAttributeReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link FacetAttributeReference.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeReference(FacetAttributeReference)}.
         * 
         * @param attributeReference
         *        a consumer that will call methods on {@link FacetAttributeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeReference(FacetAttributeReference)
         */
        default Builder attributeReference(Consumer<FacetAttributeReference.Builder> attributeReference) {
            return attributeReference(FacetAttributeReference.builder().applyMutation(attributeReference).build());
        }

        /**
         * <p>
         * The required behavior of the <code>FacetAttribute</code>.
         * </p>
         * 
         * @param requiredBehavior
         *        The required behavior of the <code>FacetAttribute</code>.
         * @see RequiredAttributeBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiredAttributeBehavior
         */
        Builder requiredBehavior(String requiredBehavior);

        /**
         * <p>
         * The required behavior of the <code>FacetAttribute</code>.
         * </p>
         * 
         * @param requiredBehavior
         *        The required behavior of the <code>FacetAttribute</code>.
         * @see RequiredAttributeBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiredAttributeBehavior
         */
        Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private FacetAttributeDefinition attributeDefinition;

        private FacetAttributeReference attributeReference;

        private String requiredBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttribute model) {
            name(model.name);
            attributeDefinition(model.attributeDefinition);
            attributeReference(model.attributeReference);
            requiredBehavior(model.requiredBehavior);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FacetAttributeDefinition.Builder getAttributeDefinition() {
            return attributeDefinition != null ? attributeDefinition.toBuilder() : null;
        }

        public final void setAttributeDefinition(FacetAttributeDefinition.BuilderImpl attributeDefinition) {
            this.attributeDefinition = attributeDefinition != null ? attributeDefinition.build() : null;
        }

        @Override
        public final Builder attributeDefinition(FacetAttributeDefinition attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
            return this;
        }

        public final FacetAttributeReference.Builder getAttributeReference() {
            return attributeReference != null ? attributeReference.toBuilder() : null;
        }

        public final void setAttributeReference(FacetAttributeReference.BuilderImpl attributeReference) {
            this.attributeReference = attributeReference != null ? attributeReference.build() : null;
        }

        @Override
        public final Builder attributeReference(FacetAttributeReference attributeReference) {
            this.attributeReference = attributeReference;
            return this;
        }

        public final String getRequiredBehavior() {
            return requiredBehavior;
        }

        public final void setRequiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
        }

        @Override
        public final Builder requiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
            return this;
        }

        @Override
        public final Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior == null ? null : requiredBehavior.toString());
            return this;
        }

        @Override
        public FacetAttribute build() {
            return new FacetAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
