/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinkAttributesRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<GetLinkAttributesRequest.Builder, GetLinkAttributesRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(GetLinkAttributesRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<TypedLinkSpecifier> TYPED_LINK_SPECIFIER_FIELD = SdkField
            .<TypedLinkSpecifier> builder(MarshallingType.SDK_POJO).memberName("TypedLinkSpecifier")
            .getter(getter(GetLinkAttributesRequest::typedLinkSpecifier)).setter(setter(Builder::typedLinkSpecifier))
            .constructor(TypedLinkSpecifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifier").build())
            .build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(GetLinkAttributesRequest::attributeNames))
            .setter(setter(Builder::attributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsistencyLevel").getter(getter(GetLinkAttributesRequest::consistencyLevelAsString))
            .setter(setter(Builder::consistencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistencyLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            TYPED_LINK_SPECIFIER_FIELD, ATTRIBUTE_NAMES_FIELD, CONSISTENCY_LEVEL_FIELD));

    private final String directoryArn;

    private final TypedLinkSpecifier typedLinkSpecifier;

    private final List<String> attributeNames;

    private final String consistencyLevel;

    private GetLinkAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeNames = builder.attributeNames;
        this.consistencyLevel = builder.consistencyLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more
     * information, see <a>arns</a> or <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For
     *         more information, see <a>arns</a> or <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Allows a typed link specifier to be accepted as input.
     * </p>
     * 
     * @return Allows a typed link specifier to be accepted as input.
     */
    public final TypedLinkSpecifier typedLinkSpecifier() {
        return typedLinkSpecifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attribute names whose values will be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return A list of attribute names whose values will be retrieved.
     */
    public final List<String> attributeNames() {
        return attributeNames;
    }

    /**
     * <p>
     * The consistency level at which to retrieve the attributes on a typed link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level at which to retrieve the attributes on a typed link.
     * @see ConsistencyLevel
     */
    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(consistencyLevel);
    }

    /**
     * <p>
     * The consistency level at which to retrieve the attributes on a typed link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level at which to retrieve the attributes on a typed link.
     * @see ConsistencyLevel
     */
    public final String consistencyLevelAsString() {
        return consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consistencyLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkAttributesRequest)) {
            return false;
        }
        GetLinkAttributesRequest other = (GetLinkAttributesRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn())
                && Objects.equals(typedLinkSpecifier(), other.typedLinkSpecifier())
                && hasAttributeNames() == other.hasAttributeNames() && Objects.equals(attributeNames(), other.attributeNames())
                && Objects.equals(consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinkAttributesRequest").add("DirectoryArn", directoryArn())
                .add("TypedLinkSpecifier", typedLinkSpecifier())
                .add("AttributeNames", hasAttributeNames() ? attributeNames() : null)
                .add("ConsistencyLevel", consistencyLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "TypedLinkSpecifier":
            return Optional.ofNullable(clazz.cast(typedLinkSpecifier()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNames()));
        case "ConsistencyLevel":
            return Optional.ofNullable(clazz.cast(consistencyLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinkAttributesRequest, T> g) {
        return obj -> g.apply((GetLinkAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLinkAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more
         * information, see <a>arns</a> or <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For
         *        more information, see <a>arns</a> or <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Allows a typed link specifier to be accepted as input.
         * </p>
         * 
         * @param typedLinkSpecifier
         *        Allows a typed link specifier to be accepted as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier);

        /**
         * <p>
         * Allows a typed link specifier to be accepted as input.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedLinkSpecifier.Builder} avoiding the
         * need to create one manually via {@link TypedLinkSpecifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSpecifier.Builder#build()} is called immediately and its
         * result is passed to {@link #typedLinkSpecifier(TypedLinkSpecifier)}.
         * 
         * @param typedLinkSpecifier
         *        a consumer that will call methods on {@link TypedLinkSpecifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typedLinkSpecifier(TypedLinkSpecifier)
         */
        default Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return typedLinkSpecifier(TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier).build());
        }

        /**
         * <p>
         * A list of attribute names whose values will be retrieved.
         * </p>
         * 
         * @param attributeNames
         *        A list of attribute names whose values will be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * A list of attribute names whose values will be retrieved.
         * </p>
         * 
         * @param attributeNames
         *        A list of attribute names whose values will be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(String... attributeNames);

        /**
         * <p>
         * The consistency level at which to retrieve the attributes on a typed link.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level at which to retrieve the attributes on a typed link.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(String consistencyLevel);

        /**
         * <p>
         * The consistency level at which to retrieve the attributes on a typed link.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level at which to retrieve the attributes on a typed link.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(ConsistencyLevel consistencyLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private TypedLinkSpecifier typedLinkSpecifier;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkAttributesRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            typedLinkSpecifier(model.typedLinkSpecifier);
            attributeNames(model.attributeNames);
            consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return typedLinkSpecifier != null ? typedLinkSpecifier.toBuilder() : null;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final String getConsistencyLevel() {
            return consistencyLevel;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLinkAttributesRequest build() {
            return new GetLinkAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
