/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObjectAttributesRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<ListObjectAttributesRequest.Builder, ListObjectAttributesRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(ListObjectAttributesRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(ListObjectAttributesRequest::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListObjectAttributesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListObjectAttributesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsistencyLevel").getter(getter(ListObjectAttributesRequest::consistencyLevelAsString))
            .setter(setter(Builder::consistencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build())
            .build();

    private static final SdkField<SchemaFacet> FACET_FILTER_FIELD = SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
            .memberName("FacetFilter").getter(getter(ListObjectAttributesRequest::facetFilter))
            .setter(setter(Builder::facetFilter)).constructor(SchemaFacet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            OBJECT_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONSISTENCY_LEVEL_FIELD, FACET_FILTER_FIELD));

    private final String directoryArn;

    private final ObjectReference objectReference;

    private final String nextToken;

    private final Integer maxResults;

    private final String consistencyLevel;

    private final SchemaFacet facetFilter;

    private ListObjectAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
        this.facetFilter = builder.facetFilter;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For more
     * information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For
     *         more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The reference that identifies the object whose attributes will be listed.
     * </p>
     * 
     * @return The reference that identifies the object whose attributes will be listed.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be retrieved in a single call. This is an approximate number.
     * </p>
     * 
     * @return The maximum number of items to be retrieved in a single call. This is an approximate number.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Represents the manner and timing in which the successful write or update of an object is reflected in a
     * subsequent read operation of that same object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return Represents the manner and timing in which the successful write or update of an object is reflected in a
     *         subsequent read operation of that same object.
     * @see ConsistencyLevel
     */
    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(consistencyLevel);
    }

    /**
     * <p>
     * Represents the manner and timing in which the successful write or update of an object is reflected in a
     * subsequent read operation of that same object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return Represents the manner and timing in which the successful write or update of an object is reflected in a
     *         subsequent read operation of that same object.
     * @see ConsistencyLevel
     */
    public final String consistencyLevelAsString() {
        return consistencyLevel;
    }

    /**
     * <p>
     * Used to filter the list of object attributes that are associated with a certain facet.
     * </p>
     * 
     * @return Used to filter the list of object attributes that are associated with a certain facet.
     */
    public final SchemaFacet facetFilter() {
        return facetFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(consistencyLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(facetFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectAttributesRequest)) {
            return false;
        }
        ListObjectAttributesRequest other = (ListObjectAttributesRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(objectReference(), other.objectReference())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(consistencyLevelAsString(), other.consistencyLevelAsString())
                && Objects.equals(facetFilter(), other.facetFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListObjectAttributesRequest").add("DirectoryArn", directoryArn())
                .add("ObjectReference", objectReference()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ConsistencyLevel", consistencyLevelAsString()).add("FacetFilter", facetFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ConsistencyLevel":
            return Optional.ofNullable(clazz.cast(consistencyLevelAsString()));
        case "FacetFilter":
            return Optional.ofNullable(clazz.cast(facetFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectAttributesRequest, T> g) {
        return obj -> g.apply((ListObjectAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListObjectAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For
         * more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
         *        For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The reference that identifies the object whose attributes will be listed.
         * </p>
         * 
         * @param objectReference
         *        The reference that identifies the object whose attributes will be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * The reference that identifies the object whose attributes will be listed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be retrieved in a single call. This is an approximate number.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be retrieved in a single call. This is an approximate number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Represents the manner and timing in which the successful write or update of an object is reflected in a
         * subsequent read operation of that same object.
         * </p>
         * 
         * @param consistencyLevel
         *        Represents the manner and timing in which the successful write or update of an object is reflected in
         *        a subsequent read operation of that same object.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(String consistencyLevel);

        /**
         * <p>
         * Represents the manner and timing in which the successful write or update of an object is reflected in a
         * subsequent read operation of that same object.
         * </p>
         * 
         * @param consistencyLevel
         *        Represents the manner and timing in which the successful write or update of an object is reflected in
         *        a subsequent read operation of that same object.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(ConsistencyLevel consistencyLevel);

        /**
         * <p>
         * Used to filter the list of object attributes that are associated with a certain facet.
         * </p>
         * 
         * @param facetFilter
         *        Used to filter the list of object attributes that are associated with a certain facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetFilter(SchemaFacet facetFilter);

        /**
         * <p>
         * Used to filter the list of object attributes that are associated with a certain facet.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaFacet.Builder} avoiding the need to
         * create one manually via {@link SchemaFacet#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaFacet.Builder#build()} is called immediately and its result
         * is passed to {@link #facetFilter(SchemaFacet)}.
         * 
         * @param facetFilter
         *        a consumer that will call methods on {@link SchemaFacet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facetFilter(SchemaFacet)
         */
        default Builder facetFilter(Consumer<SchemaFacet.Builder> facetFilter) {
            return facetFilter(SchemaFacet.builder().applyMutation(facetFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference objectReference;

        private String nextToken;

        private Integer maxResults;

        private String consistencyLevel;

        private SchemaFacet facetFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectAttributesRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            objectReference(model.objectReference);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            consistencyLevel(model.consistencyLevel);
            facetFilter(model.facetFilter);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getConsistencyLevel() {
            return consistencyLevel;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final SchemaFacet.Builder getFacetFilter() {
            return facetFilter != null ? facetFilter.toBuilder() : null;
        }

        public final void setFacetFilter(SchemaFacet.BuilderImpl facetFilter) {
            this.facetFilter = facetFilter != null ? facetFilter.build() : null;
        }

        @Override
        public final Builder facetFilter(SchemaFacet facetFilter) {
            this.facetFilter = facetFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObjectAttributesRequest build() {
            return new ListObjectAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
