/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateObjectAttributesRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<UpdateObjectAttributesRequest.Builder, UpdateObjectAttributesRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(UpdateObjectAttributesRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(UpdateObjectAttributesRequest::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<List<ObjectAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField
            .<List<ObjectAttributeUpdate>> builder(MarshallingType.LIST)
            .memberName("AttributeUpdates")
            .getter(getter(UpdateObjectAttributesRequest::attributeUpdates))
            .setter(setter(Builder::attributeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectAttributeUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectAttributeUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            OBJECT_REFERENCE_FIELD, ATTRIBUTE_UPDATES_FIELD));

    private final String directoryArn;

    private final ObjectReference objectReference;

    private final List<ObjectAttributeUpdate> attributeUpdates;

    private UpdateObjectAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.attributeUpdates = builder.attributeUpdates;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For more
     * information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For
     *         more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The reference that identifies the object.
     * </p>
     * 
     * @return The reference that identifies the object.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeUpdates() {
        return attributeUpdates != null && !(attributeUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes update structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeUpdates} method.
     * </p>
     * 
     * @return The attributes update structure.
     */
    public final List<ObjectAttributeUpdate> attributeUpdates() {
        return attributeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeUpdates() ? attributeUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateObjectAttributesRequest)) {
            return false;
        }
        UpdateObjectAttributesRequest other = (UpdateObjectAttributesRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(objectReference(), other.objectReference())
                && hasAttributeUpdates() == other.hasAttributeUpdates()
                && Objects.equals(attributeUpdates(), other.attributeUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateObjectAttributesRequest").add("DirectoryArn", directoryArn())
                .add("ObjectReference", objectReference())
                .add("AttributeUpdates", hasAttributeUpdates() ? attributeUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "AttributeUpdates":
            return Optional.ofNullable(clazz.cast(attributeUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateObjectAttributesRequest, T> g) {
        return obj -> g.apply((UpdateObjectAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateObjectAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For
         * more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
         *        For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The reference that identifies the object.
         * </p>
         * 
         * @param objectReference
         *        The reference that identifies the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * The reference that identifies the object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * The attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        The attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates);

        /**
         * <p>
         * The attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        The attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(ObjectAttributeUpdate... attributeUpdates);

        /**
         * <p>
         * The attributes update structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ObjectAttributeUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<ObjectAttributeUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectAttributeUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeUpdates(List<ObjectAttributeUpdate>)}.
         * 
         * @param attributeUpdates
         *        a consumer that will call methods on {@link List<ObjectAttributeUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeUpdates(List<ObjectAttributeUpdate>)
         */
        Builder attributeUpdates(Consumer<ObjectAttributeUpdate.Builder>... attributeUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference objectReference;

        private List<ObjectAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateObjectAttributesRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            objectReference(model.objectReference);
            attributeUpdates(model.attributeUpdates);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final List<ObjectAttributeUpdate.Builder> getAttributeUpdates() {
            List<ObjectAttributeUpdate.Builder> result = ObjectAttributeUpdateListCopier.copyToBuilder(this.attributeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeUpdates(Collection<ObjectAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public final Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(ObjectAttributeUpdate... attributeUpdates) {
            attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<ObjectAttributeUpdate.Builder>... attributeUpdates) {
            attributeUpdates(Stream.of(attributeUpdates).map(c -> ObjectAttributeUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateObjectAttributesRequest build() {
            return new UpdateObjectAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
