/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTypedLinkFacetRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<UpdateTypedLinkFacetRequest.Builder, UpdateTypedLinkFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(UpdateTypedLinkFacetRequest::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTypedLinkFacetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<TypedLinkFacetAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField
            .<List<TypedLinkFacetAttributeUpdate>> builder(MarshallingType.LIST)
            .memberName("AttributeUpdates")
            .getter(getter(UpdateTypedLinkFacetRequest::attributeUpdates))
            .setter(setter(Builder::attributeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypedLinkFacetAttributeUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypedLinkFacetAttributeUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IdentityAttributeOrder")
            .getter(getter(UpdateTypedLinkFacetRequest::identityAttributeOrder))
            .setter(setter(Builder::identityAttributeOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD,
            ATTRIBUTE_UPDATES_FIELD, IDENTITY_ATTRIBUTE_ORDER_FIELD));

    private final String schemaArn;

    private final String name;

    private final List<TypedLinkFacetAttributeUpdate> attributeUpdates;

    private final List<String> identityAttributeOrder;

    private UpdateTypedLinkFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <a>arns</a>.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The unique name of the typed link facet.
     * </p>
     * 
     * @return The unique name of the typed link facet.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeUpdates() {
        return attributeUpdates != null && !(attributeUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes update structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeUpdates} method.
     * </p>
     * 
     * @return Attributes update structure.
     */
    public final List<TypedLinkFacetAttributeUpdate> attributeUpdates() {
        return attributeUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityAttributeOrder property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityAttributeOrder() {
        return identityAttributeOrder != null && !(identityAttributeOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The order of identity attributes for the facet, from most significant to least significant. The ability to filter
     * typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to
     * a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range
     * specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the
     * typed link facet, not the order in which they are supplied to any API calls. For more information about identity
     * attributes, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityAttributeOrder} method.
     * </p>
     * 
     * @return The order of identity attributes for the facet, from most significant to least significant. The ability
     *         to filter typed links considers the order that the attributes are defined on the typed link facet. When
     *         providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any
     *         attributes that do not have a range specified are presumed to match the entire range. Filters are
     *         interpreted in the order of the attributes on the typed link facet, not the order in which they are
     *         supplied to any API calls. For more information about identity attributes, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final List<String> identityAttributeOrder() {
        return identityAttributeOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeUpdates() ? attributeUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityAttributeOrder() ? identityAttributeOrder() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTypedLinkFacetRequest)) {
            return false;
        }
        UpdateTypedLinkFacetRequest other = (UpdateTypedLinkFacetRequest) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(name(), other.name())
                && hasAttributeUpdates() == other.hasAttributeUpdates()
                && Objects.equals(attributeUpdates(), other.attributeUpdates())
                && hasIdentityAttributeOrder() == other.hasIdentityAttributeOrder()
                && Objects.equals(identityAttributeOrder(), other.identityAttributeOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTypedLinkFacetRequest").add("SchemaArn", schemaArn()).add("Name", name())
                .add("AttributeUpdates", hasAttributeUpdates() ? attributeUpdates() : null)
                .add("IdentityAttributeOrder", hasIdentityAttributeOrder() ? identityAttributeOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AttributeUpdates":
            return Optional.ofNullable(clazz.cast(attributeUpdates()));
        case "IdentityAttributeOrder":
            return Optional.ofNullable(clazz.cast(identityAttributeOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTypedLinkFacetRequest, T> g) {
        return obj -> g.apply((UpdateTypedLinkFacetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) that is associated with the schema. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The unique name of the typed link facet.
         * </p>
         * 
         * @param name
         *        The unique name of the typed link facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        Attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> attributeUpdates);

        /**
         * <p>
         * Attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        Attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(TypedLinkFacetAttributeUpdate... attributeUpdates);

        /**
         * <p>
         * Attributes update structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <TypedLinkFacetAttributeUpdate>.Builder} avoiding the need to create one manually via {@link List
         * <TypedLinkFacetAttributeUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypedLinkFacetAttributeUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeUpdates(List<TypedLinkFacetAttributeUpdate>)}.
         * 
         * @param attributeUpdates
         *        a consumer that will call methods on {@link List<TypedLinkFacetAttributeUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeUpdates(List<TypedLinkFacetAttributeUpdate>)
         */
        Builder attributeUpdates(Consumer<TypedLinkFacetAttributeUpdate.Builder>... attributeUpdates);

        /**
         * <p>
         * The order of identity attributes for the facet, from most significant to least significant. The ability to
         * filter typed links considers the order that the attributes are defined on the typed link facet. When
         * providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes
         * that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
         * order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.
         * For more information about identity attributes, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The order of identity attributes for the facet, from most significant to least significant. The
         *        ability to filter typed links considers the order that the attributes are defined on the typed link
         *        facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the
         *        end. Any attributes that do not have a range specified are presumed to match the entire range. Filters
         *        are interpreted in the order of the attributes on the typed link facet, not the order in which they
         *        are supplied to any API calls. For more information about identity attributes, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(Collection<String> identityAttributeOrder);

        /**
         * <p>
         * The order of identity attributes for the facet, from most significant to least significant. The ability to
         * filter typed links considers the order that the attributes are defined on the typed link facet. When
         * providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes
         * that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
         * order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.
         * For more information about identity attributes, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The order of identity attributes for the facet, from most significant to least significant. The
         *        ability to filter typed links considers the order that the attributes are defined on the typed link
         *        facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the
         *        end. Any attributes that do not have a range specified are presumed to match the entire range. Filters
         *        are interpreted in the order of the attributes on the typed link facet, not the order in which they
         *        are supplied to any API calls. For more information about identity attributes, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(String... identityAttributeOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String schemaArn;

        private String name;

        private List<TypedLinkFacetAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTypedLinkFacetRequest model) {
            super(model);
            schemaArn(model.schemaArn);
            name(model.name);
            attributeUpdates(model.attributeUpdates);
            identityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<TypedLinkFacetAttributeUpdate.Builder> getAttributeUpdates() {
            List<TypedLinkFacetAttributeUpdate.Builder> result = TypedLinkFacetAttributeUpdateListCopier
                    .copyToBuilder(this.attributeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeUpdates(Collection<TypedLinkFacetAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public final Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(TypedLinkFacetAttributeUpdate... attributeUpdates) {
            attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<TypedLinkFacetAttributeUpdate.Builder>... attributeUpdates) {
            attributeUpdates(Stream.of(attributeUpdates)
                    .map(c -> TypedLinkFacetAttributeUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getIdentityAttributeOrder() {
            if (identityAttributeOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return identityAttributeOrder;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String... identityAttributeOrder) {
            identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTypedLinkFacetRequest build() {
            return new UpdateTypedLinkFacetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
