/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>BatchWrite</code> exception has occurred.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteException extends CloudDirectoryException implements
        ToCopyableBuilder<BatchWriteException.Builder, BatchWriteException> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Index")
            .getter(getter(BatchWriteException::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(BatchWriteException::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final String type;

    private BatchWriteException(BuilderImpl builder) {
        super(builder);
        this.index = builder.index;
        this.type = builder.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Index property for this object.
     * 
     * @return The value of the Index property for this object.
     */
    public Integer index() {
        return index;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BatchWriteExceptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see BatchWriteExceptionType
     */
    public BatchWriteExceptionType type() {
        return BatchWriteExceptionType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BatchWriteExceptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see BatchWriteExceptionType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteException, T> g) {
        return obj -> g.apply((BatchWriteException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchWriteException>, CloudDirectoryException.Builder {
        /**
         * Sets the value of the Index property for this object.
         *
         * @param index
         *        The new value for the Index property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see BatchWriteExceptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchWriteExceptionType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see BatchWriteExceptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchWriteExceptionType
         */
        Builder type(BatchWriteExceptionType type);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends CloudDirectoryException.BuilderImpl implements Builder {
        private Integer index;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteException model) {
            super(model);
            index(model.index);
            type(model.type);
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BatchWriteExceptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BatchWriteException build() {
            return new BatchWriteException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
