/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyAttachmentsResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListPolicyAttachmentsResponse.Builder, ListPolicyAttachmentsResponse> {
    private static final SdkField<List<String>> OBJECT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ObjectIdentifiers")
            .getter(getter(ListPolicyAttachmentsResponse::objectIdentifiers))
            .setter(setter(Builder::objectIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPolicyAttachmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> objectIdentifiers;

    private final String nextToken;

    private ListPolicyAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.objectIdentifiers = builder.objectIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectIdentifiers() {
        return objectIdentifiers != null && !(objectIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ObjectIdentifiers</code> to which the policy is attached.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectIdentifiers} method.
     * </p>
     * 
     * @return A list of <code>ObjectIdentifiers</code> to which the policy is attached.
     */
    public final List<String> objectIdentifiers() {
        return objectIdentifiers;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectIdentifiers() ? objectIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyAttachmentsResponse)) {
            return false;
        }
        ListPolicyAttachmentsResponse other = (ListPolicyAttachmentsResponse) obj;
        return hasObjectIdentifiers() == other.hasObjectIdentifiers()
                && Objects.equals(objectIdentifiers(), other.objectIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPolicyAttachmentsResponse")
                .add("ObjectIdentifiers", hasObjectIdentifiers() ? objectIdentifiers() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectIdentifiers":
            return Optional.ofNullable(clazz.cast(objectIdentifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyAttachmentsResponse, T> g) {
        return obj -> g.apply((ListPolicyAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPolicyAttachmentsResponse> {
        /**
         * <p>
         * A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * </p>
         * 
         * @param objectIdentifiers
         *        A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifiers(Collection<String> objectIdentifiers);

        /**
         * <p>
         * A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * </p>
         * 
         * @param objectIdentifiers
         *        A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifiers(String... objectIdentifiers);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<String> objectIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyAttachmentsResponse model) {
            super(model);
            objectIdentifiers(model.objectIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<String> getObjectIdentifiers() {
            if (objectIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return objectIdentifiers;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String... objectIdentifiers) {
            objectIdentifiers(Arrays.asList(objectIdentifiers));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPolicyAttachmentsResponse build() {
            return new ListPolicyAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
