/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypedLinkFacetNamesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListTypedLinkFacetNamesResponse> {
    private static final SdkField<List<String>> FACET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FacetNames").getter(ListTypedLinkFacetNamesResponse.getter(ListTypedLinkFacetNamesResponse::facetNames)).setter(ListTypedLinkFacetNamesResponse.setter(Builder::facetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTypedLinkFacetNamesResponse.getter(ListTypedLinkFacetNamesResponse::nextToken)).setter(ListTypedLinkFacetNamesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACET_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FacetNames", FACET_NAMES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> facetNames;
    private final String nextToken;

    private ListTypedLinkFacetNamesResponse(BuilderImpl builder) {
        super(builder);
        this.facetNames = builder.facetNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFacetNames() {
        return this.facetNames != null && !(this.facetNames instanceof SdkAutoConstructList);
    }

    public final List<String> facetNames() {
        return this.facetNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFacetNames() ? this.facetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypedLinkFacetNamesResponse)) {
            return false;
        }
        ListTypedLinkFacetNamesResponse other = (ListTypedLinkFacetNamesResponse)((Object)obj);
        return this.hasFacetNames() == other.hasFacetNames() && Objects.equals(this.facetNames(), other.facetNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTypedLinkFacetNamesResponse").add("FacetNames", this.hasFacetNames() ? this.facetNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FacetNames": {
                return Optional.ofNullable(clazz.cast(this.facetNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTypedLinkFacetNamesResponse, T> g) {
        return obj -> g.apply((ListTypedLinkFacetNamesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> facetNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypedLinkFacetNamesResponse model) {
            super(model);
            this.facetNames(model.facetNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFacetNames() {
            if (this.facetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.facetNames;
        }

        public final void setFacetNames(Collection<String> facetNames) {
            this.facetNames = TypedLinkNameListCopier.copy(facetNames);
        }

        @Override
        public final Builder facetNames(Collection<String> facetNames) {
            this.facetNames = TypedLinkNameListCopier.copy(facetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetNames(String ... facetNames) {
            this.facetNames(Arrays.asList(facetNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTypedLinkFacetNamesResponse build() {
            return new ListTypedLinkFacetNamesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypedLinkFacetNamesResponse> {
        public Builder facetNames(Collection<String> var1);

        public Builder facetNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

