/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.clouddirectory.internal.CloudDirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.clouddirectory.model.AccessDeniedException;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteException;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse;
import software.amazon.awssdk.services.clouddirectory.model.CannotListParentOfRootException;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryException;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryDeletedException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryNotDisabledException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryNotEnabledException;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.FacetAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.FacetInUseException;
import software.amazon.awssdk.services.clouddirectory.model.FacetNotFoundException;
import software.amazon.awssdk.services.clouddirectory.model.FacetValidationException;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.IncompatibleSchemaException;
import software.amazon.awssdk.services.clouddirectory.model.IndexedAttributeMissingException;
import software.amazon.awssdk.services.clouddirectory.model.InternalServiceException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidArnException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidAttachmentException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidFacetUpdateException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidRuleException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidSchemaDocException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidTaggingRequestException;
import software.amazon.awssdk.services.clouddirectory.model.LimitExceededException;
import software.amazon.awssdk.services.clouddirectory.model.LinkNameAlreadyInUseException;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.NotIndexException;
import software.amazon.awssdk.services.clouddirectory.model.NotNodeException;
import software.amazon.awssdk.services.clouddirectory.model.NotPolicyException;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAlreadyDetachedException;
import software.amazon.awssdk.services.clouddirectory.model.ObjectNotDetachedException;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ResourceNotFoundException;
import software.amazon.awssdk.services.clouddirectory.model.RetryableConflictException;
import software.amazon.awssdk.services.clouddirectory.model.SchemaAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.SchemaAlreadyPublishedException;
import software.amazon.awssdk.services.clouddirectory.model.StillContainsLinksException;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UnsupportedIndexTypeException;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.ValidationException;
import software.amazon.awssdk.services.clouddirectory.transform.AddFacetToObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ApplySchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachToIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachTypedLinkRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachFromIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachTypedLinkRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DisableDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.EnableDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetAppliedSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetLinkAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetObjectInformationRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetSchemaAsJsonRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetTypedLinkFacetInformationRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListAppliedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListAttachedIndicesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListDevelopmentSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListFacetAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListFacetNamesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListIncomingTypedLinksRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListManagedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectChildrenRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectParentPathsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectParentsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectPoliciesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListOutgoingTypedLinksRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListPolicyAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListPublishedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTypedLinkFacetAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTypedLinkFacetNamesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.LookupPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.PublishSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.PutSchemaFromJsonRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.RemoveFacetFromObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateLinkAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpgradeAppliedSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpgradePublishedSchemaRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CloudDirectoryAsyncClient}.
 *
 * @see CloudDirectoryAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudDirectoryAsyncClient implements CloudDirectoryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudDirectoryAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudDirectoryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds a new <a>Facet</a> to an object. An object can have more than one facet applied on it.
     * </p>
     *
     * @param addFacetToObjectRequest
     * @return A Java Future containing the result of the AddFacetToObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AddFacetToObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AddFacetToObject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddFacetToObjectResponse> addFacetToObject(AddFacetToObjectRequest addFacetToObjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFacetToObjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFacetToObjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFacetToObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddFacetToObjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddFacetToObjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddFacetToObjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddFacetToObjectRequest, AddFacetToObjectResponse>()
                            .withOperationName("AddFacetToObject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddFacetToObjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addFacetToObjectRequest));
            CompletableFuture<AddFacetToObjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the input published schema, at the specified version, into the <a>Directory</a> with the same name and
     * version as that of the published schema.
     * </p>
     *
     * @param applySchemaRequest
     * @return A Java Future containing the result of the ApplySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ApplySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ApplySchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ApplySchemaResponse> applySchema(ApplySchemaRequest applySchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(applySchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, applySchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplySchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ApplySchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ApplySchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ApplySchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApplySchemaRequest, ApplySchemaResponse>()
                            .withOperationName("ApplySchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ApplySchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(applySchemaRequest));
            CompletableFuture<ApplySchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an existing object to another object. An object can be accessed in two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Using the path
     * </p>
     * </li>
     * <li>
     * <p>
     * Using <code>ObjectIdentifier</code>
     * </p>
     * </li>
     * </ol>
     *
     * @param attachObjectRequest
     * @return A Java Future containing the result of the AttachObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachObject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachObjectResponse> attachObject(AttachObjectRequest attachObjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachObjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachObjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachObjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachObjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachObjectRequest, AttachObjectResponse>()
                            .withOperationName("AttachObject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachObjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachObjectRequest));
            CompletableFuture<AttachObjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     * </p>
     *
     * @param attachPolicyRequest
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachPolicyRequest, AttachPolicyResponse>()
                            .withOperationName("AttachPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachPolicyRequest));
            CompletableFuture<AttachPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified object to the specified index.
     * </p>
     *
     * @param attachToIndexRequest
     * @return A Java Future containing the result of the AttachToIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>IndexedAttributeMissingException An object has been attempted to be attached to an object that does
     *         not have the appropriate attribute value.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachToIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachToIndex" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachToIndexResponse> attachToIndex(AttachToIndexRequest attachToIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachToIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachToIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachToIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachToIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachToIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachToIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachToIndexRequest, AttachToIndexResponse>()
                            .withOperationName("AttachToIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachToIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachToIndexRequest));
            CompletableFuture<AttachToIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a typed link to a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param attachTypedLinkRequest
     * @return A Java Future containing the result of the AttachTypedLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachTypedLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachTypedLink"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachTypedLinkResponse> attachTypedLink(AttachTypedLinkRequest attachTypedLinkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachTypedLinkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachTypedLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachTypedLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachTypedLinkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachTypedLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachTypedLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachTypedLinkRequest, AttachTypedLinkResponse>()
                            .withOperationName("AttachTypedLink").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachTypedLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachTypedLinkRequest));
            CompletableFuture<AttachTypedLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Performs all the read operations in a batch.
     * </p>
     *
     * @param batchReadRequest
     * @return A Java Future containing the result of the BatchRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.BatchRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchRead" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchReadResponse> batchRead(BatchReadRequest batchReadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchReadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchReadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchRead");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchReadResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    BatchReadResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchReadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchReadRequest, BatchReadResponse>().withOperationName("BatchRead")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchReadRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchReadRequest));
            CompletableFuture<BatchReadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Performs all the write operations in a batch. Either all the operations succeed or none.
     * </p>
     *
     * @param batchWriteRequest
     * @return A Java Future containing the result of the BatchWrite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>BatchWriteException A <code>BatchWrite</code> exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.BatchWrite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchWrite" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchWriteResponse> batchWrite(BatchWriteRequest batchWriteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchWriteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchWriteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchWrite");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchWriteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    BatchWriteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchWriteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchWriteRequest, BatchWriteResponse>().withOperationName("BatchWrite")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchWriteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchWriteRequest));
            CompletableFuture<BatchWriteResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <a>Directory</a> by copying the published schema into the directory. A directory cannot be created
     * without a schema.
     * </p>
     * <p>
     * You can also quickly create a directory using a managed schema, called the <code>QuickStartSchema</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html">Managed Schema</a>
     * in the <i>Amazon Cloud Directory Developer Guide</i>.
     * </p>
     *
     * @param createDirectoryRequest
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryAlreadyExistsException Indicates that a <a>Directory</a> could not be created due to a
     *         naming conflict. Choose a different name and try again.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDirectoryRequest, CreateDirectoryResponse>()
                            .withOperationName("CreateDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDirectoryRequest));
            CompletableFuture<CreateDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new <a>Facet</a> in a schema. Facet creation is allowed only in development or applied schemas.
     * </p>
     *
     * @param createFacetRequest
     * @return A Java Future containing the result of the CreateFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetAlreadyExistsException A facet with the same name already exists.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateFacet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFacetResponse> createFacet(CreateFacetRequest createFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFacetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFacetRequest, CreateFacetResponse>()
                            .withOperationName("CreateFacet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFacetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFacetRequest));
            CompletableFuture<CreateFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an index object. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html">Indexing and
     * search</a> for more information.
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>UnsupportedIndexTypeException Indicates that the requested index type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateIndex" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIndexRequest, CreateIndexResponse>()
                            .withOperationName("CreateIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIndexRequest));
            CompletableFuture<CreateIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an object in a <a>Directory</a>. Additionally attaches the object to a parent, if a parent reference and
     * <code>LinkName</code> is specified. An object is simply a collection of <a>Facet</a> attributes. You can also use
     * this API call to create a policy object, if the facet from which you create the object is a policy facet.
     * </p>
     *
     * @param createObjectRequest
     * @return A Java Future containing the result of the CreateObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>UnsupportedIndexTypeException Indicates that the requested index type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateObject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateObjectResponse> createObject(CreateObjectRequest createObjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createObjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateObjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateObjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateObjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateObjectRequest, CreateObjectResponse>()
                            .withOperationName("CreateObject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateObjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createObjectRequest));
            CompletableFuture<CreateObjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new schema in a development state. A schema can exist in three phases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Development:</i> This is a mutable phase of the schema. All new schemas are in the development phase. Once the
     * schema is finalized, it can be published.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Published:</i> Published schemas are immutable and have a version associated with them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Applied:</i> Applied schemas are mutable in a way that allows you to add new schema facets. You can also add
     * new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
     * </p>
     * </li>
     * </ul>
     *
     * @param createSchemaRequest
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateSchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSchemaRequest, CreateSchemaResponse>()
                            .withOperationName("CreateSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSchemaRequest));
            CompletableFuture<CreateSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param createTypedLinkFacetRequest
     * @return A Java Future containing the result of the CreateTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetAlreadyExistsException A facet with the same name already exists.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTypedLinkFacetResponse> createTypedLinkFacet(
            CreateTypedLinkFacetRequest createTypedLinkFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTypedLinkFacetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTypedLinkFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTypedLinkFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTypedLinkFacetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTypedLinkFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTypedLinkFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTypedLinkFacetRequest, CreateTypedLinkFacetResponse>()
                            .withOperationName("CreateTypedLinkFacet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTypedLinkFacetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTypedLinkFacetRequest));
            CompletableFuture<CreateTypedLinkFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise
     * extreme caution when deleting directories.
     * </p>
     *
     * @param deleteDirectoryRequest
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryNotDisabledException An operation can only operate on a disabled directory.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectoryRequest, DeleteDirectoryResponse>()
                            .withOperationName("DeleteDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDirectoryRequest));
            CompletableFuture<DeleteDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a given <a>Facet</a>. All attributes and <a>Rule</a>s that are associated with the facet will be deleted.
     * Only development schema facets are allowed deletion.
     * </p>
     *
     * @param deleteFacetRequest
     * @return A Java Future containing the result of the DeleteFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>FacetInUseException Occurs when deleting a facet that contains an attribute that is a target to an
     *         attribute reference in a different facet.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteFacet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFacetResponse> deleteFacet(DeleteFacetRequest deleteFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFacetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFacetRequest, DeleteFacetResponse>()
                            .withOperationName("DeleteFacet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFacetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFacetRequest));
            CompletableFuture<DeleteFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The
     * maximum number of attributes that can be deleted during an object deletion is 30. For more information, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory
     * Limits</a>.
     * </p>
     *
     * @param deleteObjectRequest
     * @return A Java Future containing the result of the DeleteObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ObjectNotDetachedException Indicates that the requested operation cannot be completed because the
     *         object has not been detached from the tree.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteObject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteObjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteObjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteObjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteObjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteObjectRequest, DeleteObjectResponse>()
                            .withOperationName("DeleteObject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteObjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteObjectRequest));
            CompletableFuture<DeleteObjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a given schema. Schemas in a development and published state can only be deleted.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>StillContainsLinksException The object could not be deleted because links still exist. Remove the
     *         links and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteSchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSchemaRequest, DeleteSchemaResponse>()
                            .withOperationName("DeleteSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSchemaRequest));
            CompletableFuture<DeleteSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param deleteTypedLinkFacetRequest
     * @return A Java Future containing the result of the DeleteTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTypedLinkFacetResponse> deleteTypedLinkFacet(
            DeleteTypedLinkFacetRequest deleteTypedLinkFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTypedLinkFacetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTypedLinkFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTypedLinkFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTypedLinkFacetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTypedLinkFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTypedLinkFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTypedLinkFacetRequest, DeleteTypedLinkFacetResponse>()
                            .withOperationName("DeleteTypedLinkFacet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTypedLinkFacetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTypedLinkFacetRequest));
            CompletableFuture<DeleteTypedLinkFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches the specified object from the specified index.
     * </p>
     *
     * @param detachFromIndexRequest
     * @return A Java Future containing the result of the DetachFromIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ObjectAlreadyDetachedException Indicates that the object is not attached to the index.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachFromIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachFromIndex"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachFromIndexResponse> detachFromIndex(DetachFromIndexRequest detachFromIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachFromIndexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachFromIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachFromIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachFromIndexResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachFromIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachFromIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachFromIndexRequest, DetachFromIndexResponse>()
                            .withOperationName("DetachFromIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachFromIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachFromIndexRequest));
            CompletableFuture<DetachFromIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by
     * the link name.
     * </p>
     *
     * @param detachObjectRequest
     * @return A Java Future containing the result of the DetachObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachObject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachObjectResponse> detachObject(DetachObjectRequest detachObjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachObjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachObjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetachObjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachObjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachObjectRequest, DetachObjectResponse>()
                            .withOperationName("DetachObject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachObjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachObjectRequest));
            CompletableFuture<DetachObjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a policy from an object.
     * </p>
     *
     * @param detachPolicyRequest
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetachPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachPolicyRequest, DetachPolicyResponse>()
                            .withOperationName("DetachPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachPolicyRequest));
            CompletableFuture<DetachPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a typed link from a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param detachTypedLinkRequest
     * @return A Java Future containing the result of the DetachTypedLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachTypedLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachTypedLink"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachTypedLinkResponse> detachTypedLink(DetachTypedLinkRequest detachTypedLinkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachTypedLinkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachTypedLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachTypedLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachTypedLinkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachTypedLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachTypedLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachTypedLinkRequest, DetachTypedLinkResponse>()
                            .withOperationName("DetachTypedLink").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachTypedLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachTypedLinkRequest));
            CompletableFuture<DetachTypedLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can
     * be disabled. Disabled directories may be reenabled.
     * </p>
     *
     * @param disableDirectoryRequest
     * @return A Java Future containing the result of the DisableDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DisableDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DisableDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableDirectoryResponse> disableDirectory(DisableDirectoryRequest disableDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableDirectoryRequest, DisableDirectoryResponse>()
                            .withOperationName("DisableDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableDirectoryRequest));
            CompletableFuture<DisableDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then
     * be read and written to.
     * </p>
     *
     * @param enableDirectoryRequest
     * @return A Java Future containing the result of the EnableDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.EnableDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/EnableDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableDirectoryResponse> enableDirectory(EnableDirectoryRequest enableDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableDirectoryRequest, EnableDirectoryResponse>()
                            .withOperationName("EnableDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableDirectoryRequest));
            CompletableFuture<EnableDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns current applied schema version ARN, including the minor version in use.
     * </p>
     *
     * @param getAppliedSchemaVersionRequest
     * @return A Java Future containing the result of the GetAppliedSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetAppliedSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetAppliedSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAppliedSchemaVersionResponse> getAppliedSchemaVersion(
            GetAppliedSchemaVersionRequest getAppliedSchemaVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAppliedSchemaVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppliedSchemaVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAppliedSchemaVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAppliedSchemaVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAppliedSchemaVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAppliedSchemaVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAppliedSchemaVersionRequest, GetAppliedSchemaVersionResponse>()
                            .withOperationName("GetAppliedSchemaVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAppliedSchemaVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAppliedSchemaVersionRequest));
            CompletableFuture<GetAppliedSchemaVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves metadata about a directory.
     * </p>
     *
     * @param getDirectoryRequest
     * @return A Java Future containing the result of the GetDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDirectoryResponse> getDirectory(GetDirectoryRequest getDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDirectoryRequest, GetDirectoryResponse>()
                            .withOperationName("GetDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDirectoryRequest));
            CompletableFuture<GetDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details of the <a>Facet</a>, such as facet name, attributes, <a>Rule</a>s, or <code>ObjectType</code>. You
     * can call this on all kinds of schema facets -- published, development, or applied.
     * </p>
     *
     * @param getFacetRequest
     * @return A Java Future containing the result of the GetFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetFacet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFacetResponse> getFacet(GetFacetRequest getFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFacetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFacetRequest, GetFacetResponse>().withOperationName("GetFacet")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFacetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFacetRequest));
            CompletableFuture<GetFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves attributes that are associated with a typed link.
     * </p>
     *
     * @param getLinkAttributesRequest
     * @return A Java Future containing the result of the GetLinkAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetLinkAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetLinkAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLinkAttributesResponse> getLinkAttributes(GetLinkAttributesRequest getLinkAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLinkAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLinkAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLinkAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLinkAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLinkAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLinkAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLinkAttributesRequest, GetLinkAttributesResponse>()
                            .withOperationName("GetLinkAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLinkAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLinkAttributesRequest));
            CompletableFuture<GetLinkAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves attributes within a facet that are associated with an object.
     * </p>
     *
     * @param getObjectAttributesRequest
     * @return A Java Future containing the result of the GetObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetObjectAttributesResponse> getObjectAttributes(
            GetObjectAttributesRequest getObjectAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getObjectAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getObjectAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetObjectAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetObjectAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetObjectAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetObjectAttributesRequest, GetObjectAttributesResponse>()
                            .withOperationName("GetObjectAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetObjectAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getObjectAttributesRequest));
            CompletableFuture<GetObjectAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves metadata about an object.
     * </p>
     *
     * @param getObjectInformationRequest
     * @return A Java Future containing the result of the GetObjectInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetObjectInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetObjectInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetObjectInformationResponse> getObjectInformation(
            GetObjectInformationRequest getObjectInformationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getObjectInformationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getObjectInformationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetObjectInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetObjectInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetObjectInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetObjectInformationRequest, GetObjectInformationResponse>()
                            .withOperationName("GetObjectInformation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetObjectInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getObjectInformationRequest));
            CompletableFuture<GetObjectInformationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a JSON representation of the schema. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON
     * Schema Format</a> for more information.
     * </p>
     *
     * @param getSchemaAsJsonRequest
     * @return A Java Future containing the result of the GetSchemaAsJson operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetSchemaAsJson
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetSchemaAsJson"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSchemaAsJsonResponse> getSchemaAsJson(GetSchemaAsJsonRequest getSchemaAsJsonRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaAsJsonRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaAsJsonRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaAsJson");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSchemaAsJsonResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSchemaAsJsonResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSchemaAsJsonResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSchemaAsJsonRequest, GetSchemaAsJsonResponse>()
                            .withOperationName("GetSchemaAsJson").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSchemaAsJsonRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSchemaAsJsonRequest));
            CompletableFuture<GetSchemaAsJsonResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the identity attribute order for a specific <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param getTypedLinkFacetInformationRequest
     * @return A Java Future containing the result of the GetTypedLinkFacetInformation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetTypedLinkFacetInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetTypedLinkFacetInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTypedLinkFacetInformationResponse> getTypedLinkFacetInformation(
            GetTypedLinkFacetInformationRequest getTypedLinkFacetInformationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTypedLinkFacetInformationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTypedLinkFacetInformationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTypedLinkFacetInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTypedLinkFacetInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTypedLinkFacetInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTypedLinkFacetInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTypedLinkFacetInformationRequest, GetTypedLinkFacetInformationResponse>()
                            .withOperationName("GetTypedLinkFacetInformation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTypedLinkFacetInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTypedLinkFacetInformationRequest));
            CompletableFuture<GetTypedLinkFacetInformationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor
     * version.
     * </p>
     *
     * @param listAppliedSchemaArnsRequest
     * @return A Java Future containing the result of the ListAppliedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAppliedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAppliedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppliedSchemaArnsResponse> listAppliedSchemaArns(
            ListAppliedSchemaArnsRequest listAppliedSchemaArnsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppliedSchemaArnsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppliedSchemaArnsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppliedSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppliedSchemaArnsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppliedSchemaArnsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppliedSchemaArnsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppliedSchemaArnsRequest, ListAppliedSchemaArnsResponse>()
                            .withOperationName("ListAppliedSchemaArns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppliedSchemaArnsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppliedSchemaArnsRequest));
            CompletableFuture<ListAppliedSchemaArnsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists indices attached to the specified object.
     * </p>
     *
     * @param listAttachedIndicesRequest
     * @return A Java Future containing the result of the ListAttachedIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAttachedIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAttachedIndices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAttachedIndicesResponse> listAttachedIndices(
            ListAttachedIndicesRequest listAttachedIndicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAttachedIndicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedIndicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedIndices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAttachedIndicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAttachedIndicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAttachedIndicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAttachedIndicesRequest, ListAttachedIndicesResponse>()
                            .withOperationName("ListAttachedIndices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAttachedIndicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAttachedIndicesRequest));
            CompletableFuture<ListAttachedIndicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     *
     * @param listDevelopmentSchemaArnsRequest
     * @return A Java Future containing the result of the ListDevelopmentSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevelopmentSchemaArnsResponse> listDevelopmentSchemaArns(
            ListDevelopmentSchemaArnsRequest listDevelopmentSchemaArnsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDevelopmentSchemaArnsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevelopmentSchemaArnsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevelopmentSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDevelopmentSchemaArnsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDevelopmentSchemaArnsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDevelopmentSchemaArnsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDevelopmentSchemaArnsRequest, ListDevelopmentSchemaArnsResponse>()
                            .withOperationName("ListDevelopmentSchemaArns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDevelopmentSchemaArnsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDevelopmentSchemaArnsRequest));
            CompletableFuture<ListDevelopmentSchemaArnsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     *
     * @param listDirectoriesRequest
     * @return A Java Future containing the result of the ListDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDirectoriesResponse> listDirectories(ListDirectoriesRequest listDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDirectoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDirectoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDirectoriesRequest, ListDirectoriesResponse>()
                            .withOperationName("ListDirectories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDirectoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDirectoriesRequest));
            CompletableFuture<ListDirectoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves attributes attached to the facet.
     * </p>
     *
     * @param listFacetAttributesRequest
     * @return A Java Future containing the result of the ListFacetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFacetAttributesResponse> listFacetAttributes(
            ListFacetAttributesRequest listFacetAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFacetAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFacetAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFacetAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFacetAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFacetAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFacetAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFacetAttributesRequest, ListFacetAttributesResponse>()
                            .withOperationName("ListFacetAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFacetAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFacetAttributesRequest));
            CompletableFuture<ListFacetAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the names of facets that exist in a schema.
     * </p>
     *
     * @param listFacetNamesRequest
     * @return A Java Future containing the result of the ListFacetNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetNames" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFacetNamesResponse> listFacetNames(ListFacetNamesRequest listFacetNamesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFacetNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFacetNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFacetNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFacetNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFacetNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFacetNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFacetNamesRequest, ListFacetNamesResponse>()
                            .withOperationName("ListFacetNames").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFacetNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFacetNamesRequest));
            CompletableFuture<ListFacetNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listIncomingTypedLinksRequest
     * @return A Java Future containing the result of the ListIncomingTypedLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIncomingTypedLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIncomingTypedLinks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIncomingTypedLinksResponse> listIncomingTypedLinks(
            ListIncomingTypedLinksRequest listIncomingTypedLinksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIncomingTypedLinksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIncomingTypedLinksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIncomingTypedLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIncomingTypedLinksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIncomingTypedLinksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIncomingTypedLinksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIncomingTypedLinksRequest, ListIncomingTypedLinksResponse>()
                            .withOperationName("ListIncomingTypedLinks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIncomingTypedLinksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIncomingTypedLinksRequest));
            CompletableFuture<ListIncomingTypedLinksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     *
     * @param listIndexRequest
     * @return A Java Future containing the result of the ListIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIndexResponse> listIndex(ListIndexRequest listIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIndexRequest, ListIndexResponse>().withOperationName("ListIndex")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIndexRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIndexRequest));
            CompletableFuture<ListIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     *
     * @param listManagedSchemaArnsRequest
     * @return A Java Future containing the result of the ListManagedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListManagedSchemaArnsResponse> listManagedSchemaArns(
            ListManagedSchemaArnsRequest listManagedSchemaArnsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedSchemaArnsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedSchemaArnsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListManagedSchemaArnsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListManagedSchemaArnsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListManagedSchemaArnsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListManagedSchemaArnsRequest, ListManagedSchemaArnsResponse>()
                            .withOperationName("ListManagedSchemaArns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListManagedSchemaArnsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listManagedSchemaArnsRequest));
            CompletableFuture<ListManagedSchemaArnsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     *
     * @param listObjectAttributesRequest
     * @return A Java Future containing the result of the ListObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListObjectAttributesResponse> listObjectAttributes(
            ListObjectAttributesRequest listObjectAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listObjectAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listObjectAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListObjectAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListObjectAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListObjectAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListObjectAttributesRequest, ListObjectAttributesResponse>()
                            .withOperationName("ListObjectAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListObjectAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listObjectAttributesRequest));
            CompletableFuture<ListObjectAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     *
     * @param listObjectChildrenRequest
     * @return A Java Future containing the result of the ListObjectChildren operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectChildren
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectChildren"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListObjectChildrenResponse> listObjectChildren(ListObjectChildrenRequest listObjectChildrenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listObjectChildrenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listObjectChildrenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectChildren");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListObjectChildrenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListObjectChildrenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListObjectChildrenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListObjectChildrenRequest, ListObjectChildrenResponse>()
                            .withOperationName("ListObjectChildren").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListObjectChildrenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listObjectChildrenRequest));
            CompletableFuture<ListObjectChildrenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * <p>
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory
     * up to the requested object. The API returns the number of paths based on user-defined <code>MaxResults</code>, in
     * case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among
     * multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored
     * from the target object.
     * </p>
     *
     * @param listObjectParentPathsRequest
     * @return A Java Future containing the result of the ListObjectParentPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParentPaths"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListObjectParentPathsResponse> listObjectParentPaths(
            ListObjectParentPathsRequest listObjectParentPathsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listObjectParentPathsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listObjectParentPathsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectParentPaths");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListObjectParentPathsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListObjectParentPathsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListObjectParentPathsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListObjectParentPathsRequest, ListObjectParentPathsResponse>()
                            .withOperationName("ListObjectParentPaths").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListObjectParentPathsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listObjectParentPathsRequest));
            CompletableFuture<ListObjectParentPathsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists parent objects that are associated with a given object in pagination fashion.
     * </p>
     *
     * @param listObjectParentsRequest
     * @return A Java Future containing the result of the ListObjectParents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>CannotListParentOfRootException Cannot list the parents of a <a>Directory</a> root.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListObjectParentsResponse> listObjectParents(ListObjectParentsRequest listObjectParentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listObjectParentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listObjectParentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectParents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListObjectParentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListObjectParentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListObjectParentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListObjectParentsRequest, ListObjectParentsResponse>()
                            .withOperationName("ListObjectParents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListObjectParentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listObjectParentsRequest));
            CompletableFuture<ListObjectParentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     *
     * @param listObjectPoliciesRequest
     * @return A Java Future containing the result of the ListObjectPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListObjectPoliciesResponse> listObjectPolicies(ListObjectPoliciesRequest listObjectPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listObjectPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listObjectPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListObjectPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListObjectPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListObjectPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListObjectPoliciesRequest, ListObjectPoliciesResponse>()
                            .withOperationName("ListObjectPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListObjectPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listObjectPoliciesRequest));
            CompletableFuture<ListObjectPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listOutgoingTypedLinksRequest
     * @return A Java Future containing the result of the ListOutgoingTypedLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListOutgoingTypedLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListOutgoingTypedLinks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOutgoingTypedLinksResponse> listOutgoingTypedLinks(
            ListOutgoingTypedLinksRequest listOutgoingTypedLinksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOutgoingTypedLinksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOutgoingTypedLinksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOutgoingTypedLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOutgoingTypedLinksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOutgoingTypedLinksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOutgoingTypedLinksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOutgoingTypedLinksRequest, ListOutgoingTypedLinksResponse>()
                            .withOperationName("ListOutgoingTypedLinks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOutgoingTypedLinksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOutgoingTypedLinksRequest));
            CompletableFuture<ListOutgoingTypedLinksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     *
     * @param listPolicyAttachmentsRequest
     * @return A Java Future containing the result of the ListPolicyAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPolicyAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPolicyAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPolicyAttachmentsResponse> listPolicyAttachments(
            ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPolicyAttachmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPolicyAttachmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicyAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPolicyAttachmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPolicyAttachmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPolicyAttachmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPolicyAttachmentsRequest, ListPolicyAttachmentsResponse>()
                            .withOperationName("ListPolicyAttachments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPolicyAttachmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPolicyAttachmentsRequest));
            CompletableFuture<ListPolicyAttachmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     *
     * @param listPublishedSchemaArnsRequest
     * @return A Java Future containing the result of the ListPublishedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPublishedSchemaArnsResponse> listPublishedSchemaArns(
            ListPublishedSchemaArnsRequest listPublishedSchemaArnsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPublishedSchemaArnsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPublishedSchemaArnsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPublishedSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPublishedSchemaArnsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPublishedSchemaArnsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPublishedSchemaArnsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPublishedSchemaArnsRequest, ListPublishedSchemaArnsResponse>()
                            .withOperationName("ListPublishedSchemaArns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPublishedSchemaArnsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPublishedSchemaArnsRequest));
            CompletableFuture<ListPublishedSchemaArnsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per
     * directory. All 50 tags are returned for a given directory with this API call.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of all attribute definitions for a particular <a>TypedLinkFacet</a>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listTypedLinkFacetAttributesRequest
     * @return A Java Future containing the result of the ListTypedLinkFacetAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTypedLinkFacetAttributesResponse> listTypedLinkFacetAttributes(
            ListTypedLinkFacetAttributesRequest listTypedLinkFacetAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypedLinkFacetAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypedLinkFacetAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypedLinkFacetAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTypedLinkFacetAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTypedLinkFacetAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTypedLinkFacetAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTypedLinkFacetAttributesRequest, ListTypedLinkFacetAttributesResponse>()
                            .withOperationName("ListTypedLinkFacetAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTypedLinkFacetAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTypedLinkFacetAttributesRequest));
            CompletableFuture<ListTypedLinkFacetAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of <code>TypedLink</code> facet names for a particular schema. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listTypedLinkFacetNamesRequest
     * @return A Java Future containing the result of the ListTypedLinkFacetNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetNames"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTypedLinkFacetNamesResponse> listTypedLinkFacetNames(
            ListTypedLinkFacetNamesRequest listTypedLinkFacetNamesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypedLinkFacetNamesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypedLinkFacetNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypedLinkFacetNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTypedLinkFacetNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTypedLinkFacetNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTypedLinkFacetNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTypedLinkFacetNamesRequest, ListTypedLinkFacetNamesResponse>()
                            .withOperationName("ListTypedLinkFacetNames").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTypedLinkFacetNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTypedLinkFacetNamesRequest));
            CompletableFuture<ListTypedLinkFacetNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     *
     * @param lookupPolicyRequest
     * @return A Java Future containing the result of the LookupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.LookupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LookupPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<LookupPolicyResponse> lookupPolicy(LookupPolicyRequest lookupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(lookupPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, lookupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "LookupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<LookupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    LookupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<LookupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<LookupPolicyRequest, LookupPolicyResponse>()
                            .withOperationName("LookupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new LookupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(lookupPolicyRequest));
            CompletableFuture<LookupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Publishes a development schema with a major version and a recommended minor version.
     * </p>
     *
     * @param publishSchemaRequest
     * @return A Java Future containing the result of the PublishSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SchemaAlreadyPublishedException Indicates that a schema is already published.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.PublishSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PublishSchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PublishSchemaResponse> publishSchema(PublishSchemaRequest publishSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(publishSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PublishSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PublishSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PublishSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PublishSchemaRequest, PublishSchemaResponse>()
                            .withOperationName("PublishSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PublishSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(publishSchemaRequest));
            CompletableFuture<PublishSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a schema to be updated using JSON upload. Only available for development schemas. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON
     * Schema Format</a> for more information.
     * </p>
     *
     * @param putSchemaFromJsonRequest
     * @return A Java Future containing the result of the PutSchemaFromJson operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidSchemaDocException Indicates that the provided <code>SchemaDoc</code> value is not valid.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.PutSchemaFromJson
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PutSchemaFromJson"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutSchemaFromJsonResponse> putSchemaFromJson(PutSchemaFromJsonRequest putSchemaFromJsonRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSchemaFromJsonRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSchemaFromJsonRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSchemaFromJson");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSchemaFromJsonResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutSchemaFromJsonResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutSchemaFromJsonResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSchemaFromJsonRequest, PutSchemaFromJsonResponse>()
                            .withOperationName("PutSchemaFromJson").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutSchemaFromJsonRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putSchemaFromJsonRequest));
            CompletableFuture<PutSchemaFromJsonResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified facet from the specified object.
     * </p>
     *
     * @param removeFacetFromObjectRequest
     * @return A Java Future containing the result of the RemoveFacetFromObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.RemoveFacetFromObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/RemoveFacetFromObject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveFacetFromObjectResponse> removeFacetFromObject(
            RemoveFacetFromObjectRequest removeFacetFromObjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFacetFromObjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFacetFromObjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFacetFromObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveFacetFromObjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveFacetFromObjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveFacetFromObjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveFacetFromObjectRequest, RemoveFacetFromObjectResponse>()
                            .withOperationName("RemoveFacetFromObject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveFacetFromObjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeFacetFromObjectRequest));
            CompletableFuture<RemoveFacetFromObjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An API operation for adding tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An API operation for removing tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Adds new <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Updates existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deletes existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateFacetRequest
     * @return A Java Future containing the result of the UpdateFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidFacetUpdateException An attempt to modify a <a>Facet</a> resulted in an invalid schema
     *         exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateFacet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFacetResponse> updateFacet(UpdateFacetRequest updateFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFacetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFacetRequest, UpdateFacetResponse>()
                            .withOperationName("UpdateFacet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFacetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFacetRequest));
            CompletableFuture<UpdateFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s
     * identity, as defined by its <code>IdentityAttributeOrder</code>.
     * </p>
     *
     * @param updateLinkAttributesRequest
     * @return A Java Future containing the result of the UpdateLinkAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateLinkAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateLinkAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLinkAttributesResponse> updateLinkAttributes(
            UpdateLinkAttributesRequest updateLinkAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLinkAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLinkAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLinkAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLinkAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLinkAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLinkAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLinkAttributesRequest, UpdateLinkAttributesResponse>()
                            .withOperationName("UpdateLinkAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateLinkAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateLinkAttributesRequest));
            CompletableFuture<UpdateLinkAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a given object's attributes.
     * </p>
     *
     * @param updateObjectAttributesRequest
     * @return A Java Future containing the result of the UpdateObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateObjectAttributesResponse> updateObjectAttributes(
            UpdateObjectAttributesRequest updateObjectAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateObjectAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateObjectAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateObjectAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateObjectAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateObjectAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateObjectAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateObjectAttributesRequest, UpdateObjectAttributesResponse>()
                            .withOperationName("UpdateObjectAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateObjectAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateObjectAttributesRequest));
            CompletableFuture<UpdateObjectAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the schema name with a new name. Only development schema names can be updated.
     * </p>
     *
     * @param updateSchemaRequest
     * @return A Java Future containing the result of the UpdateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateSchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSchemaResponse> updateSchema(UpdateSchemaRequest updateSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSchemaRequest, UpdateSchemaResponse>()
                            .withOperationName("UpdateSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSchemaRequest));
            CompletableFuture<UpdateSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param updateTypedLinkFacetRequest
     * @return A Java Future containing the result of the UpdateTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>InvalidFacetUpdateException An attempt to modify a <a>Facet</a> resulted in an invalid schema
     *         exception.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTypedLinkFacetResponse> updateTypedLinkFacet(
            UpdateTypedLinkFacetRequest updateTypedLinkFacetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTypedLinkFacetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTypedLinkFacetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTypedLinkFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTypedLinkFacetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTypedLinkFacetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTypedLinkFacetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTypedLinkFacetRequest, UpdateTypedLinkFacetResponse>()
                            .withOperationName("UpdateTypedLinkFacet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTypedLinkFacetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTypedLinkFacetRequest));
            CompletableFuture<UpdateTypedLinkFacetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Upgrades a single directory in-place using the <code>PublishedSchemaArn</code> with schema updates found in
     * <code>MinorVersion</code>. Backwards-compatible minor version upgrades are instantaneously available for readers
     * on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given
     * directory per call. To upgrade multiple directories from one schema, you would need to call this API on each
     * directory.
     * </p>
     *
     * @param upgradeAppliedSchemaRequest
     * @return A Java Future containing the result of the UpgradeAppliedSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>IncompatibleSchemaException Indicates a failure occurred while performing a check for backward
     *         compatibility between the specified schema and the schema that is currently applied to the directory.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpgradeAppliedSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpgradeAppliedSchema"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpgradeAppliedSchemaResponse> upgradeAppliedSchema(
            UpgradeAppliedSchemaRequest upgradeAppliedSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(upgradeAppliedSchemaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, upgradeAppliedSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpgradeAppliedSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpgradeAppliedSchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpgradeAppliedSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpgradeAppliedSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpgradeAppliedSchemaRequest, UpgradeAppliedSchemaResponse>()
                            .withOperationName("UpgradeAppliedSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpgradeAppliedSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(upgradeAppliedSchemaRequest));
            CompletableFuture<UpgradeAppliedSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Upgrades a published schema under a new minor version revision using the current contents of
     * <code>DevelopmentSchemaArn</code>.
     * </p>
     *
     * @param upgradePublishedSchemaRequest
     * @return A Java Future containing the result of the UpgradePublishedSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>IncompatibleSchemaException Indicates a failure occurred while performing a check for backward
     *         compatibility between the specified schema and the schema that is currently applied to the directory.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpgradePublishedSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpgradePublishedSchema"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpgradePublishedSchemaResponse> upgradePublishedSchema(
            UpgradePublishedSchemaRequest upgradePublishedSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(upgradePublishedSchemaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, upgradePublishedSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpgradePublishedSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpgradePublishedSchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpgradePublishedSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpgradePublishedSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpgradePublishedSchemaRequest, UpgradePublishedSchemaResponse>()
                            .withOperationName("UpgradePublishedSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpgradePublishedSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(upgradePublishedSchemaRequest));
            CompletableFuture<UpgradePublishedSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CloudDirectoryServiceClientConfiguration serviceClientConfiguration() {
        return new CloudDirectoryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CloudDirectoryException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArnException")
                                .exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FacetInUseException")
                                .exceptionBuilderSupplier(FacetInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAttachmentException")
                                .exceptionBuilderSupplier(InvalidAttachmentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException")
                                .exceptionBuilderSupplier(IndexedAttributeMissingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleSchemaException")
                                .exceptionBuilderSupplier(IncompatibleSchemaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException")
                                .exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StillContainsLinksException")
                                .exceptionBuilderSupplier(StillContainsLinksException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRuleException")
                                .exceptionBuilderSupplier(InvalidRuleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException")
                                .exceptionBuilderSupplier(DirectoryNotEnabledException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FacetValidationException")
                                .exceptionBuilderSupplier(FacetValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException")
                                .exceptionBuilderSupplier(InvalidFacetUpdateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException")
                                .exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceException")
                                .exceptionBuilderSupplier(InternalServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException")
                                .exceptionBuilderSupplier(FacetAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotIndexException")
                                .exceptionBuilderSupplier(NotIndexException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException")
                                .exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryDeletedException")
                                .exceptionBuilderSupplier(DirectoryDeletedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RetryableConflictException")
                                .exceptionBuilderSupplier(RetryableConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchWriteException")
                                .exceptionBuilderSupplier(BatchWriteException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException")
                                .exceptionBuilderSupplier(InvalidTaggingRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotNodeException")
                                .exceptionBuilderSupplier(NotNodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException")
                                .exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException")
                                .exceptionBuilderSupplier(DirectoryNotDisabledException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSchemaDocException")
                                .exceptionBuilderSupplier(InvalidSchemaDocException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ObjectNotDetachedException")
                                .exceptionBuilderSupplier(ObjectNotDetachedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException")
                                .exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotListParentOfRootException")
                                .exceptionBuilderSupplier(CannotListParentOfRootException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotPolicyException")
                                .exceptionBuilderSupplier(NotPolicyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FacetNotFoundException")
                                .exceptionBuilderSupplier(FacetNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException")
                                .exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CloudDirectoryServiceClientConfigurationBuilder serviceConfigBuilder = new CloudDirectoryServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
