/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>ListObjectChildren</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListObjectChildrenResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListObjectChildrenResponse.Builder, BatchListObjectChildrenResponse> {
    private static final SdkField<Map<String, String>> CHILDREN_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Children")
            .getter(getter(BatchListObjectChildrenResponse::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListObjectChildrenResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILDREN_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> children;

    private final String nextToken;

    private BatchListObjectChildrenResponse(BuilderImpl builder) {
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Children property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The children structure, which is a map with the key as the <code>LinkName</code> and
     * <code>ObjectIdentifier</code> as the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildren} method.
     * </p>
     * 
     * @return The children structure, which is a map with the key as the <code>LinkName</code> and
     *         <code>ObjectIdentifier</code> as the value.
     */
    public final Map<String, String> children() {
        return children;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChildren() ? children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectChildrenResponse)) {
            return false;
        }
        BatchListObjectChildrenResponse other = (BatchListObjectChildrenResponse) obj;
        return hasChildren() == other.hasChildren() && Objects.equals(children(), other.children())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListObjectChildrenResponse").add("Children", hasChildren() ? children() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Children":
            return Optional.ofNullable(clazz.cast(children()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Children", CHILDREN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectChildrenResponse, T> g) {
        return obj -> g.apply((BatchListObjectChildrenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListObjectChildrenResponse> {
        /**
         * <p>
         * The children structure, which is a map with the key as the <code>LinkName</code> and
         * <code>ObjectIdentifier</code> as the value.
         * </p>
         * 
         * @param children
         *        The children structure, which is a map with the key as the <code>LinkName</code> and
         *        <code>ObjectIdentifier</code> as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Map<String, String> children);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> children = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectChildrenResponse model) {
            children(model.children);
            nextToken(model.nextToken);
        }

        public final Map<String, String> getChildren() {
            if (children instanceof SdkAutoConstructMap) {
                return null;
            }
            return children;
        }

        public final void setChildren(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
        }

        @Override
        public final Builder children(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchListObjectChildrenResponse build() {
            return new BatchListObjectChildrenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
