/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponseListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, BatchWriteResponse> {
    private static final SdkField<List<BatchWriteOperationResponse>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Responses").getter(BatchWriteResponse.getter(BatchWriteResponse::responses)).setter(BatchWriteResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchWriteOperationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchWriteResponse.memberNameToFieldInitializer();
    private final List<BatchWriteOperationResponse> responses;

    private BatchWriteResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    public final boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructList);
    }

    public final List<BatchWriteOperationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponses() ? this.responses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteResponse)) {
            return false;
        }
        BatchWriteResponse other = (BatchWriteResponse)((Object)obj);
        return this.hasResponses() == other.hasResponses() && Objects.equals(this.responses(), other.responses());
    }

    public final String toString() {
        return ToString.builder((String)"BatchWriteResponse").add("Responses", this.hasResponses() ? this.responses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchWriteOperationResponse>>> map = new HashMap<String, SdkField<List<BatchWriteOperationResponse>>>();
        map.put("Responses", RESPONSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteResponse, T> g) {
        return obj -> g.apply((BatchWriteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<BatchWriteOperationResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteResponse model) {
            super(model);
            this.responses(model.responses);
        }

        public final List<BatchWriteOperationResponse.Builder> getResponses() {
            List<BatchWriteOperationResponse.Builder> result = BatchWriteOperationResponseListCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<BatchWriteOperationResponse.BuilderImpl> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public final Builder responses(Collection<BatchWriteOperationResponse> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchWriteOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<BatchWriteOperationResponse.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (BatchWriteOperationResponse)((BatchWriteOperationResponse.Builder)BatchWriteOperationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchWriteResponse build() {
            return new BatchWriteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchWriteResponse> {
        public Builder responses(Collection<BatchWriteOperationResponse> var1);

        public Builder responses(BatchWriteOperationResponse ... var1);

        public Builder responses(Consumer<BatchWriteOperationResponse.Builder> ... var1);
    }
}

