/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>ListIncomingTypedLinks</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListIncomingTypedLinksResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListIncomingTypedLinksResponse.Builder, BatchListIncomingTypedLinksResponse> {
    private static final SdkField<List<TypedLinkSpecifier>> LINK_SPECIFIERS_FIELD = SdkField
            .<List<TypedLinkSpecifier>> builder(MarshallingType.LIST)
            .memberName("LinkSpecifiers")
            .getter(getter(BatchListIncomingTypedLinksResponse::linkSpecifiers))
            .setter(setter(Builder::linkSpecifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSpecifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypedLinkSpecifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypedLinkSpecifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListIncomingTypedLinksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_SPECIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TypedLinkSpecifier> linkSpecifiers;

    private final String nextToken;

    private BatchListIncomingTypedLinksResponse(BuilderImpl builder) {
        this.linkSpecifiers = builder.linkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkSpecifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkSpecifiers() {
        return linkSpecifiers != null && !(linkSpecifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns one or more typed link specifiers as output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkSpecifiers} method.
     * </p>
     * 
     * @return Returns one or more typed link specifiers as output.
     */
    public final List<TypedLinkSpecifier> linkSpecifiers() {
        return linkSpecifiers;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkSpecifiers() ? linkSpecifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIncomingTypedLinksResponse)) {
            return false;
        }
        BatchListIncomingTypedLinksResponse other = (BatchListIncomingTypedLinksResponse) obj;
        return hasLinkSpecifiers() == other.hasLinkSpecifiers() && Objects.equals(linkSpecifiers(), other.linkSpecifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListIncomingTypedLinksResponse")
                .add("LinkSpecifiers", hasLinkSpecifiers() ? linkSpecifiers() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkSpecifiers":
            return Optional.ofNullable(clazz.cast(linkSpecifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LinkSpecifiers", LINK_SPECIFIERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchListIncomingTypedLinksResponse, T> g) {
        return obj -> g.apply((BatchListIncomingTypedLinksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListIncomingTypedLinksResponse> {
        /**
         * <p>
         * Returns one or more typed link specifiers as output.
         * </p>
         * 
         * @param linkSpecifiers
         *        Returns one or more typed link specifiers as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers);

        /**
         * <p>
         * Returns one or more typed link specifiers as output.
         * </p>
         * 
         * @param linkSpecifiers
         *        Returns one or more typed link specifiers as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkSpecifiers(TypedLinkSpecifier... linkSpecifiers);

        /**
         * <p>
         * Returns one or more typed link specifiers as output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier.Builder#build()} is called
         * immediately and its result is passed to {@link #linkSpecifiers(List<TypedLinkSpecifier>)}.
         * 
         * @param linkSpecifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkSpecifiers(java.util.Collection<TypedLinkSpecifier>)
         */
        Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder>... linkSpecifiers);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<TypedLinkSpecifier> linkSpecifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIncomingTypedLinksResponse model) {
            linkSpecifiers(model.linkSpecifiers);
            nextToken(model.nextToken);
        }

        public final List<TypedLinkSpecifier.Builder> getLinkSpecifiers() {
            List<TypedLinkSpecifier.Builder> result = TypedLinkSpecifierListCopier.copyToBuilder(this.linkSpecifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(linkSpecifiers);
        }

        @Override
        public final Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copy(linkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(TypedLinkSpecifier... linkSpecifiers) {
            linkSpecifiers(Arrays.asList(linkSpecifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder>... linkSpecifiers) {
            linkSpecifiers(Stream.of(linkSpecifiers).map(c -> TypedLinkSpecifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchListIncomingTypedLinksResponse build() {
            return new BatchListIncomingTypedLinksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
