/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>ListObjectAttributes</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListObjectAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListObjectAttributes.Builder, BatchListObjectAttributes> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(BatchListObjectAttributes::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListObjectAttributes::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(BatchListObjectAttributes::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<SchemaFacet> FACET_FILTER_FIELD = SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
            .memberName("FacetFilter").getter(getter(BatchListObjectAttributes::facetFilter))
            .setter(setter(Builder::facetFilter)).constructor(SchemaFacet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FACET_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ObjectReference objectReference;

    private final String nextToken;

    private final Integer maxResults;

    private final SchemaFacet facetFilter;

    private BatchListObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.facetFilter = builder.facetFilter;
    }

    /**
     * <p>
     * Reference of the object whose attributes need to be listed.
     * </p>
     * 
     * @return Reference of the object whose attributes need to be listed.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be retrieved in a single call. This is an approximate number.
     * </p>
     * 
     * @return The maximum number of items to be retrieved in a single call. This is an approximate number.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Used to filter the list of object attributes that are associated with a certain facet.
     * </p>
     * 
     * @return Used to filter the list of object attributes that are associated with a certain facet.
     */
    public final SchemaFacet facetFilter() {
        return facetFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(facetFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectAttributes)) {
            return false;
        }
        BatchListObjectAttributes other = (BatchListObjectAttributes) obj;
        return Objects.equals(objectReference(), other.objectReference()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(facetFilter(), other.facetFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListObjectAttributes").add("ObjectReference", objectReference())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("FacetFilter", facetFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "FacetFilter":
            return Optional.ofNullable(clazz.cast(facetFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectReference", OBJECT_REFERENCE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("FacetFilter", FACET_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectAttributes, T> g) {
        return obj -> g.apply((BatchListObjectAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListObjectAttributes> {
        /**
         * <p>
         * Reference of the object whose attributes need to be listed.
         * </p>
         * 
         * @param objectReference
         *        Reference of the object whose attributes need to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * Reference of the object whose attributes need to be listed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be retrieved in a single call. This is an approximate number.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be retrieved in a single call. This is an approximate number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Used to filter the list of object attributes that are associated with a certain facet.
         * </p>
         * 
         * @param facetFilter
         *        Used to filter the list of object attributes that are associated with a certain facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetFilter(SchemaFacet facetFilter);

        /**
         * <p>
         * Used to filter the list of object attributes that are associated with a certain facet.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaFacet.Builder} avoiding the need to
         * create one manually via {@link SchemaFacet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaFacet.Builder#build()} is called immediately and its result
         * is passed to {@link #facetFilter(SchemaFacet)}.
         * 
         * @param facetFilter
         *        a consumer that will call methods on {@link SchemaFacet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facetFilter(SchemaFacet)
         */
        default Builder facetFilter(Consumer<SchemaFacet.Builder> facetFilter) {
            return facetFilter(SchemaFacet.builder().applyMutation(facetFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference objectReference;

        private String nextToken;

        private Integer maxResults;

        private SchemaFacet facetFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectAttributes model) {
            objectReference(model.objectReference);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            facetFilter(model.facetFilter);
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SchemaFacet.Builder getFacetFilter() {
            return facetFilter != null ? facetFilter.toBuilder() : null;
        }

        public final void setFacetFilter(SchemaFacet.BuilderImpl facetFilter) {
            this.facetFilter = facetFilter != null ? facetFilter.build() : null;
        }

        @Override
        public final Builder facetFilter(SchemaFacet facetFilter) {
            this.facetFilter = facetFilter;
            return this;
        }

        @Override
        public BatchListObjectAttributes build() {
            return new BatchListObjectAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
