/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchWrite</code> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteOperationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchWriteOperationResponse.Builder, BatchWriteOperationResponse> {
    private static final SdkField<BatchCreateObjectResponse> CREATE_OBJECT_FIELD = SdkField
            .<BatchCreateObjectResponse> builder(MarshallingType.SDK_POJO).memberName("CreateObject")
            .getter(getter(BatchWriteOperationResponse::createObject)).setter(setter(Builder::createObject))
            .constructor(BatchCreateObjectResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateObject").build()).build();

    private static final SdkField<BatchAttachObjectResponse> ATTACH_OBJECT_FIELD = SdkField
            .<BatchAttachObjectResponse> builder(MarshallingType.SDK_POJO).memberName("AttachObject")
            .getter(getter(BatchWriteOperationResponse::attachObject)).setter(setter(Builder::attachObject))
            .constructor(BatchAttachObjectResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachObject").build()).build();

    private static final SdkField<BatchDetachObjectResponse> DETACH_OBJECT_FIELD = SdkField
            .<BatchDetachObjectResponse> builder(MarshallingType.SDK_POJO).memberName("DetachObject")
            .getter(getter(BatchWriteOperationResponse::detachObject)).setter(setter(Builder::detachObject))
            .constructor(BatchDetachObjectResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachObject").build()).build();

    private static final SdkField<BatchUpdateObjectAttributesResponse> UPDATE_OBJECT_ATTRIBUTES_FIELD = SdkField
            .<BatchUpdateObjectAttributesResponse> builder(MarshallingType.SDK_POJO).memberName("UpdateObjectAttributes")
            .getter(getter(BatchWriteOperationResponse::updateObjectAttributes)).setter(setter(Builder::updateObjectAttributes))
            .constructor(BatchUpdateObjectAttributesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateObjectAttributes").build())
            .build();

    private static final SdkField<BatchDeleteObjectResponse> DELETE_OBJECT_FIELD = SdkField
            .<BatchDeleteObjectResponse> builder(MarshallingType.SDK_POJO).memberName("DeleteObject")
            .getter(getter(BatchWriteOperationResponse::deleteObject)).setter(setter(Builder::deleteObject))
            .constructor(BatchDeleteObjectResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteObject").build()).build();

    private static final SdkField<BatchAddFacetToObjectResponse> ADD_FACET_TO_OBJECT_FIELD = SdkField
            .<BatchAddFacetToObjectResponse> builder(MarshallingType.SDK_POJO).memberName("AddFacetToObject")
            .getter(getter(BatchWriteOperationResponse::addFacetToObject)).setter(setter(Builder::addFacetToObject))
            .constructor(BatchAddFacetToObjectResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddFacetToObject").build()).build();

    private static final SdkField<BatchRemoveFacetFromObjectResponse> REMOVE_FACET_FROM_OBJECT_FIELD = SdkField
            .<BatchRemoveFacetFromObjectResponse> builder(MarshallingType.SDK_POJO).memberName("RemoveFacetFromObject")
            .getter(getter(BatchWriteOperationResponse::removeFacetFromObject)).setter(setter(Builder::removeFacetFromObject))
            .constructor(BatchRemoveFacetFromObjectResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveFacetFromObject").build())
            .build();

    private static final SdkField<BatchAttachPolicyResponse> ATTACH_POLICY_FIELD = SdkField
            .<BatchAttachPolicyResponse> builder(MarshallingType.SDK_POJO).memberName("AttachPolicy")
            .getter(getter(BatchWriteOperationResponse::attachPolicy)).setter(setter(Builder::attachPolicy))
            .constructor(BatchAttachPolicyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachPolicy").build()).build();

    private static final SdkField<BatchDetachPolicyResponse> DETACH_POLICY_FIELD = SdkField
            .<BatchDetachPolicyResponse> builder(MarshallingType.SDK_POJO).memberName("DetachPolicy")
            .getter(getter(BatchWriteOperationResponse::detachPolicy)).setter(setter(Builder::detachPolicy))
            .constructor(BatchDetachPolicyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachPolicy").build()).build();

    private static final SdkField<BatchCreateIndexResponse> CREATE_INDEX_FIELD = SdkField
            .<BatchCreateIndexResponse> builder(MarshallingType.SDK_POJO).memberName("CreateIndex")
            .getter(getter(BatchWriteOperationResponse::createIndex)).setter(setter(Builder::createIndex))
            .constructor(BatchCreateIndexResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateIndex").build()).build();

    private static final SdkField<BatchAttachToIndexResponse> ATTACH_TO_INDEX_FIELD = SdkField
            .<BatchAttachToIndexResponse> builder(MarshallingType.SDK_POJO).memberName("AttachToIndex")
            .getter(getter(BatchWriteOperationResponse::attachToIndex)).setter(setter(Builder::attachToIndex))
            .constructor(BatchAttachToIndexResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachToIndex").build()).build();

    private static final SdkField<BatchDetachFromIndexResponse> DETACH_FROM_INDEX_FIELD = SdkField
            .<BatchDetachFromIndexResponse> builder(MarshallingType.SDK_POJO).memberName("DetachFromIndex")
            .getter(getter(BatchWriteOperationResponse::detachFromIndex)).setter(setter(Builder::detachFromIndex))
            .constructor(BatchDetachFromIndexResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachFromIndex").build()).build();

    private static final SdkField<BatchAttachTypedLinkResponse> ATTACH_TYPED_LINK_FIELD = SdkField
            .<BatchAttachTypedLinkResponse> builder(MarshallingType.SDK_POJO).memberName("AttachTypedLink")
            .getter(getter(BatchWriteOperationResponse::attachTypedLink)).setter(setter(Builder::attachTypedLink))
            .constructor(BatchAttachTypedLinkResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTypedLink").build()).build();

    private static final SdkField<BatchDetachTypedLinkResponse> DETACH_TYPED_LINK_FIELD = SdkField
            .<BatchDetachTypedLinkResponse> builder(MarshallingType.SDK_POJO).memberName("DetachTypedLink")
            .getter(getter(BatchWriteOperationResponse::detachTypedLink)).setter(setter(Builder::detachTypedLink))
            .constructor(BatchDetachTypedLinkResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachTypedLink").build()).build();

    private static final SdkField<BatchUpdateLinkAttributesResponse> UPDATE_LINK_ATTRIBUTES_FIELD = SdkField
            .<BatchUpdateLinkAttributesResponse> builder(MarshallingType.SDK_POJO).memberName("UpdateLinkAttributes")
            .getter(getter(BatchWriteOperationResponse::updateLinkAttributes)).setter(setter(Builder::updateLinkAttributes))
            .constructor(BatchUpdateLinkAttributesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateLinkAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_OBJECT_FIELD,
            ATTACH_OBJECT_FIELD, DETACH_OBJECT_FIELD, UPDATE_OBJECT_ATTRIBUTES_FIELD, DELETE_OBJECT_FIELD,
            ADD_FACET_TO_OBJECT_FIELD, REMOVE_FACET_FROM_OBJECT_FIELD, ATTACH_POLICY_FIELD, DETACH_POLICY_FIELD,
            CREATE_INDEX_FIELD, ATTACH_TO_INDEX_FIELD, DETACH_FROM_INDEX_FIELD, ATTACH_TYPED_LINK_FIELD, DETACH_TYPED_LINK_FIELD,
            UPDATE_LINK_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BatchCreateObjectResponse createObject;

    private final BatchAttachObjectResponse attachObject;

    private final BatchDetachObjectResponse detachObject;

    private final BatchUpdateObjectAttributesResponse updateObjectAttributes;

    private final BatchDeleteObjectResponse deleteObject;

    private final BatchAddFacetToObjectResponse addFacetToObject;

    private final BatchRemoveFacetFromObjectResponse removeFacetFromObject;

    private final BatchAttachPolicyResponse attachPolicy;

    private final BatchDetachPolicyResponse detachPolicy;

    private final BatchCreateIndexResponse createIndex;

    private final BatchAttachToIndexResponse attachToIndex;

    private final BatchDetachFromIndexResponse detachFromIndex;

    private final BatchAttachTypedLinkResponse attachTypedLink;

    private final BatchDetachTypedLinkResponse detachTypedLink;

    private final BatchUpdateLinkAttributesResponse updateLinkAttributes;

    private BatchWriteOperationResponse(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
        this.attachPolicy = builder.attachPolicy;
        this.detachPolicy = builder.detachPolicy;
        this.createIndex = builder.createIndex;
        this.attachToIndex = builder.attachToIndex;
        this.detachFromIndex = builder.detachFromIndex;
        this.attachTypedLink = builder.attachTypedLink;
        this.detachTypedLink = builder.detachTypedLink;
        this.updateLinkAttributes = builder.updateLinkAttributes;
    }

    /**
     * <p>
     * Creates an object in a <a>Directory</a>.
     * </p>
     * 
     * @return Creates an object in a <a>Directory</a>.
     */
    public final BatchCreateObjectResponse createObject() {
        return createObject;
    }

    /**
     * <p>
     * Attaches an object to a <a>Directory</a>.
     * </p>
     * 
     * @return Attaches an object to a <a>Directory</a>.
     */
    public final BatchAttachObjectResponse attachObject() {
        return attachObject;
    }

    /**
     * <p>
     * Detaches an object from a <a>Directory</a>.
     * </p>
     * 
     * @return Detaches an object from a <a>Directory</a>.
     */
    public final BatchDetachObjectResponse detachObject() {
        return detachObject;
    }

    /**
     * <p>
     * Updates a given object’s attributes.
     * </p>
     * 
     * @return Updates a given object’s attributes.
     */
    public final BatchUpdateObjectAttributesResponse updateObjectAttributes() {
        return updateObjectAttributes;
    }

    /**
     * <p>
     * Deletes an object in a <a>Directory</a>.
     * </p>
     * 
     * @return Deletes an object in a <a>Directory</a>.
     */
    public final BatchDeleteObjectResponse deleteObject() {
        return deleteObject;
    }

    /**
     * <p>
     * The result of an add facet to object batch operation.
     * </p>
     * 
     * @return The result of an add facet to object batch operation.
     */
    public final BatchAddFacetToObjectResponse addFacetToObject() {
        return addFacetToObject;
    }

    /**
     * <p>
     * The result of a batch remove facet from object operation.
     * </p>
     * 
     * @return The result of a batch remove facet from object operation.
     */
    public final BatchRemoveFacetFromObjectResponse removeFacetFromObject() {
        return removeFacetFromObject;
    }

    /**
     * <p>
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     * </p>
     * 
     * @return Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     */
    public final BatchAttachPolicyResponse attachPolicy() {
        return attachPolicy;
    }

    /**
     * <p>
     * Detaches a policy from a <a>Directory</a>.
     * </p>
     * 
     * @return Detaches a policy from a <a>Directory</a>.
     */
    public final BatchDetachPolicyResponse detachPolicy() {
        return detachPolicy;
    }

    /**
     * <p>
     * Creates an index object. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
     * search</a> for more information.
     * </p>
     * 
     * @return Creates an index object. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
     *         search</a> for more information.
     */
    public final BatchCreateIndexResponse createIndex() {
        return createIndex;
    }

    /**
     * <p>
     * Attaches the specified object to the specified index.
     * </p>
     * 
     * @return Attaches the specified object to the specified index.
     */
    public final BatchAttachToIndexResponse attachToIndex() {
        return attachToIndex;
    }

    /**
     * <p>
     * Detaches the specified object from the specified index.
     * </p>
     * 
     * @return Detaches the specified object from the specified index.
     */
    public final BatchDetachFromIndexResponse detachFromIndex() {
        return detachFromIndex;
    }

    /**
     * <p>
     * Attaches a typed link to a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Attaches a typed link to a specified source and target object. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchAttachTypedLinkResponse attachTypedLink() {
        return attachTypedLink;
    }

    /**
     * <p>
     * Detaches a typed link from a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Detaches a typed link from a specified source and target object. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchDetachTypedLinkResponse detachTypedLink() {
        return detachTypedLink;
    }

    /**
     * <p>
     * Represents the output of a <code>BatchWrite</code> response operation.
     * </p>
     * 
     * @return Represents the output of a <code>BatchWrite</code> response operation.
     */
    public final BatchUpdateLinkAttributesResponse updateLinkAttributes() {
        return updateLinkAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createObject());
        hashCode = 31 * hashCode + Objects.hashCode(attachObject());
        hashCode = 31 * hashCode + Objects.hashCode(detachObject());
        hashCode = 31 * hashCode + Objects.hashCode(updateObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(deleteObject());
        hashCode = 31 * hashCode + Objects.hashCode(addFacetToObject());
        hashCode = 31 * hashCode + Objects.hashCode(removeFacetFromObject());
        hashCode = 31 * hashCode + Objects.hashCode(attachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(detachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(createIndex());
        hashCode = 31 * hashCode + Objects.hashCode(attachToIndex());
        hashCode = 31 * hashCode + Objects.hashCode(detachFromIndex());
        hashCode = 31 * hashCode + Objects.hashCode(attachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(detachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(updateLinkAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperationResponse)) {
            return false;
        }
        BatchWriteOperationResponse other = (BatchWriteOperationResponse) obj;
        return Objects.equals(createObject(), other.createObject()) && Objects.equals(attachObject(), other.attachObject())
                && Objects.equals(detachObject(), other.detachObject())
                && Objects.equals(updateObjectAttributes(), other.updateObjectAttributes())
                && Objects.equals(deleteObject(), other.deleteObject())
                && Objects.equals(addFacetToObject(), other.addFacetToObject())
                && Objects.equals(removeFacetFromObject(), other.removeFacetFromObject())
                && Objects.equals(attachPolicy(), other.attachPolicy()) && Objects.equals(detachPolicy(), other.detachPolicy())
                && Objects.equals(createIndex(), other.createIndex()) && Objects.equals(attachToIndex(), other.attachToIndex())
                && Objects.equals(detachFromIndex(), other.detachFromIndex())
                && Objects.equals(attachTypedLink(), other.attachTypedLink())
                && Objects.equals(detachTypedLink(), other.detachTypedLink())
                && Objects.equals(updateLinkAttributes(), other.updateLinkAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchWriteOperationResponse").add("CreateObject", createObject())
                .add("AttachObject", attachObject()).add("DetachObject", detachObject())
                .add("UpdateObjectAttributes", updateObjectAttributes()).add("DeleteObject", deleteObject())
                .add("AddFacetToObject", addFacetToObject()).add("RemoveFacetFromObject", removeFacetFromObject())
                .add("AttachPolicy", attachPolicy()).add("DetachPolicy", detachPolicy()).add("CreateIndex", createIndex())
                .add("AttachToIndex", attachToIndex()).add("DetachFromIndex", detachFromIndex())
                .add("AttachTypedLink", attachTypedLink()).add("DetachTypedLink", detachTypedLink())
                .add("UpdateLinkAttributes", updateLinkAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateObject":
            return Optional.ofNullable(clazz.cast(createObject()));
        case "AttachObject":
            return Optional.ofNullable(clazz.cast(attachObject()));
        case "DetachObject":
            return Optional.ofNullable(clazz.cast(detachObject()));
        case "UpdateObjectAttributes":
            return Optional.ofNullable(clazz.cast(updateObjectAttributes()));
        case "DeleteObject":
            return Optional.ofNullable(clazz.cast(deleteObject()));
        case "AddFacetToObject":
            return Optional.ofNullable(clazz.cast(addFacetToObject()));
        case "RemoveFacetFromObject":
            return Optional.ofNullable(clazz.cast(removeFacetFromObject()));
        case "AttachPolicy":
            return Optional.ofNullable(clazz.cast(attachPolicy()));
        case "DetachPolicy":
            return Optional.ofNullable(clazz.cast(detachPolicy()));
        case "CreateIndex":
            return Optional.ofNullable(clazz.cast(createIndex()));
        case "AttachToIndex":
            return Optional.ofNullable(clazz.cast(attachToIndex()));
        case "DetachFromIndex":
            return Optional.ofNullable(clazz.cast(detachFromIndex()));
        case "AttachTypedLink":
            return Optional.ofNullable(clazz.cast(attachTypedLink()));
        case "DetachTypedLink":
            return Optional.ofNullable(clazz.cast(detachTypedLink()));
        case "UpdateLinkAttributes":
            return Optional.ofNullable(clazz.cast(updateLinkAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreateObject", CREATE_OBJECT_FIELD);
        map.put("AttachObject", ATTACH_OBJECT_FIELD);
        map.put("DetachObject", DETACH_OBJECT_FIELD);
        map.put("UpdateObjectAttributes", UPDATE_OBJECT_ATTRIBUTES_FIELD);
        map.put("DeleteObject", DELETE_OBJECT_FIELD);
        map.put("AddFacetToObject", ADD_FACET_TO_OBJECT_FIELD);
        map.put("RemoveFacetFromObject", REMOVE_FACET_FROM_OBJECT_FIELD);
        map.put("AttachPolicy", ATTACH_POLICY_FIELD);
        map.put("DetachPolicy", DETACH_POLICY_FIELD);
        map.put("CreateIndex", CREATE_INDEX_FIELD);
        map.put("AttachToIndex", ATTACH_TO_INDEX_FIELD);
        map.put("DetachFromIndex", DETACH_FROM_INDEX_FIELD);
        map.put("AttachTypedLink", ATTACH_TYPED_LINK_FIELD);
        map.put("DetachTypedLink", DETACH_TYPED_LINK_FIELD);
        map.put("UpdateLinkAttributes", UPDATE_LINK_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteOperationResponse, T> g) {
        return obj -> g.apply((BatchWriteOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchWriteOperationResponse> {
        /**
         * <p>
         * Creates an object in a <a>Directory</a>.
         * </p>
         * 
         * @param createObject
         *        Creates an object in a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createObject(BatchCreateObjectResponse createObject);

        /**
         * <p>
         * Creates an object in a <a>Directory</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchCreateObjectResponse.Builder}
         * avoiding the need to create one manually via {@link BatchCreateObjectResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchCreateObjectResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #createObject(BatchCreateObjectResponse)}.
         * 
         * @param createObject
         *        a consumer that will call methods on {@link BatchCreateObjectResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createObject(BatchCreateObjectResponse)
         */
        default Builder createObject(Consumer<BatchCreateObjectResponse.Builder> createObject) {
            return createObject(BatchCreateObjectResponse.builder().applyMutation(createObject).build());
        }

        /**
         * <p>
         * Attaches an object to a <a>Directory</a>.
         * </p>
         * 
         * @param attachObject
         *        Attaches an object to a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachObject(BatchAttachObjectResponse attachObject);

        /**
         * <p>
         * Attaches an object to a <a>Directory</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchAttachObjectResponse.Builder}
         * avoiding the need to create one manually via {@link BatchAttachObjectResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchAttachObjectResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #attachObject(BatchAttachObjectResponse)}.
         * 
         * @param attachObject
         *        a consumer that will call methods on {@link BatchAttachObjectResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachObject(BatchAttachObjectResponse)
         */
        default Builder attachObject(Consumer<BatchAttachObjectResponse.Builder> attachObject) {
            return attachObject(BatchAttachObjectResponse.builder().applyMutation(attachObject).build());
        }

        /**
         * <p>
         * Detaches an object from a <a>Directory</a>.
         * </p>
         * 
         * @param detachObject
         *        Detaches an object from a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachObject(BatchDetachObjectResponse detachObject);

        /**
         * <p>
         * Detaches an object from a <a>Directory</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDetachObjectResponse.Builder}
         * avoiding the need to create one manually via {@link BatchDetachObjectResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDetachObjectResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #detachObject(BatchDetachObjectResponse)}.
         * 
         * @param detachObject
         *        a consumer that will call methods on {@link BatchDetachObjectResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachObject(BatchDetachObjectResponse)
         */
        default Builder detachObject(Consumer<BatchDetachObjectResponse.Builder> detachObject) {
            return detachObject(BatchDetachObjectResponse.builder().applyMutation(detachObject).build());
        }

        /**
         * <p>
         * Updates a given object’s attributes.
         * </p>
         * 
         * @param updateObjectAttributes
         *        Updates a given object’s attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse updateObjectAttributes);

        /**
         * <p>
         * Updates a given object’s attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchUpdateObjectAttributesResponse.Builder} avoiding the need to create one manually via
         * {@link BatchUpdateObjectAttributesResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchUpdateObjectAttributesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #updateObjectAttributes(BatchUpdateObjectAttributesResponse)}.
         * 
         * @param updateObjectAttributes
         *        a consumer that will call methods on {@link BatchUpdateObjectAttributesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateObjectAttributes(BatchUpdateObjectAttributesResponse)
         */
        default Builder updateObjectAttributes(Consumer<BatchUpdateObjectAttributesResponse.Builder> updateObjectAttributes) {
            return updateObjectAttributes(BatchUpdateObjectAttributesResponse.builder().applyMutation(updateObjectAttributes)
                    .build());
        }

        /**
         * <p>
         * Deletes an object in a <a>Directory</a>.
         * </p>
         * 
         * @param deleteObject
         *        Deletes an object in a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteObject(BatchDeleteObjectResponse deleteObject);

        /**
         * <p>
         * Deletes an object in a <a>Directory</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDeleteObjectResponse.Builder}
         * avoiding the need to create one manually via {@link BatchDeleteObjectResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDeleteObjectResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #deleteObject(BatchDeleteObjectResponse)}.
         * 
         * @param deleteObject
         *        a consumer that will call methods on {@link BatchDeleteObjectResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteObject(BatchDeleteObjectResponse)
         */
        default Builder deleteObject(Consumer<BatchDeleteObjectResponse.Builder> deleteObject) {
            return deleteObject(BatchDeleteObjectResponse.builder().applyMutation(deleteObject).build());
        }

        /**
         * <p>
         * The result of an add facet to object batch operation.
         * </p>
         * 
         * @param addFacetToObject
         *        The result of an add facet to object batch operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addFacetToObject(BatchAddFacetToObjectResponse addFacetToObject);

        /**
         * <p>
         * The result of an add facet to object batch operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchAddFacetToObjectResponse.Builder}
         * avoiding the need to create one manually via {@link BatchAddFacetToObjectResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchAddFacetToObjectResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #addFacetToObject(BatchAddFacetToObjectResponse)}.
         * 
         * @param addFacetToObject
         *        a consumer that will call methods on {@link BatchAddFacetToObjectResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addFacetToObject(BatchAddFacetToObjectResponse)
         */
        default Builder addFacetToObject(Consumer<BatchAddFacetToObjectResponse.Builder> addFacetToObject) {
            return addFacetToObject(BatchAddFacetToObjectResponse.builder().applyMutation(addFacetToObject).build());
        }

        /**
         * <p>
         * The result of a batch remove facet from object operation.
         * </p>
         * 
         * @param removeFacetFromObject
         *        The result of a batch remove facet from object operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse removeFacetFromObject);

        /**
         * <p>
         * The result of a batch remove facet from object operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchRemoveFacetFromObjectResponse.Builder} avoiding the need to create one manually via
         * {@link BatchRemoveFacetFromObjectResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchRemoveFacetFromObjectResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #removeFacetFromObject(BatchRemoveFacetFromObjectResponse)}.
         * 
         * @param removeFacetFromObject
         *        a consumer that will call methods on {@link BatchRemoveFacetFromObjectResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeFacetFromObject(BatchRemoveFacetFromObjectResponse)
         */
        default Builder removeFacetFromObject(Consumer<BatchRemoveFacetFromObjectResponse.Builder> removeFacetFromObject) {
            return removeFacetFromObject(BatchRemoveFacetFromObjectResponse.builder().applyMutation(removeFacetFromObject)
                    .build());
        }

        /**
         * <p>
         * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
         * </p>
         * 
         * @param attachPolicy
         *        Attaches a policy object to a regular object. An object can have a limited number of attached
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachPolicy(BatchAttachPolicyResponse attachPolicy);

        /**
         * <p>
         * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchAttachPolicyResponse.Builder}
         * avoiding the need to create one manually via {@link BatchAttachPolicyResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchAttachPolicyResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #attachPolicy(BatchAttachPolicyResponse)}.
         * 
         * @param attachPolicy
         *        a consumer that will call methods on {@link BatchAttachPolicyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachPolicy(BatchAttachPolicyResponse)
         */
        default Builder attachPolicy(Consumer<BatchAttachPolicyResponse.Builder> attachPolicy) {
            return attachPolicy(BatchAttachPolicyResponse.builder().applyMutation(attachPolicy).build());
        }

        /**
         * <p>
         * Detaches a policy from a <a>Directory</a>.
         * </p>
         * 
         * @param detachPolicy
         *        Detaches a policy from a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachPolicy(BatchDetachPolicyResponse detachPolicy);

        /**
         * <p>
         * Detaches a policy from a <a>Directory</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDetachPolicyResponse.Builder}
         * avoiding the need to create one manually via {@link BatchDetachPolicyResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDetachPolicyResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #detachPolicy(BatchDetachPolicyResponse)}.
         * 
         * @param detachPolicy
         *        a consumer that will call methods on {@link BatchDetachPolicyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachPolicy(BatchDetachPolicyResponse)
         */
        default Builder detachPolicy(Consumer<BatchDetachPolicyResponse.Builder> detachPolicy) {
            return detachPolicy(BatchDetachPolicyResponse.builder().applyMutation(detachPolicy).build());
        }

        /**
         * <p>
         * Creates an index object. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
         * search</a> for more information.
         * </p>
         * 
         * @param createIndex
         *        Creates an index object. See <a
         *        href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing
         *        and search</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createIndex(BatchCreateIndexResponse createIndex);

        /**
         * <p>
         * Creates an index object. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
         * search</a> for more information.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchCreateIndexResponse.Builder}
         * avoiding the need to create one manually via {@link BatchCreateIndexResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchCreateIndexResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #createIndex(BatchCreateIndexResponse)}.
         * 
         * @param createIndex
         *        a consumer that will call methods on {@link BatchCreateIndexResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createIndex(BatchCreateIndexResponse)
         */
        default Builder createIndex(Consumer<BatchCreateIndexResponse.Builder> createIndex) {
            return createIndex(BatchCreateIndexResponse.builder().applyMutation(createIndex).build());
        }

        /**
         * <p>
         * Attaches the specified object to the specified index.
         * </p>
         * 
         * @param attachToIndex
         *        Attaches the specified object to the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachToIndex(BatchAttachToIndexResponse attachToIndex);

        /**
         * <p>
         * Attaches the specified object to the specified index.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchAttachToIndexResponse.Builder}
         * avoiding the need to create one manually via {@link BatchAttachToIndexResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchAttachToIndexResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #attachToIndex(BatchAttachToIndexResponse)}.
         * 
         * @param attachToIndex
         *        a consumer that will call methods on {@link BatchAttachToIndexResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachToIndex(BatchAttachToIndexResponse)
         */
        default Builder attachToIndex(Consumer<BatchAttachToIndexResponse.Builder> attachToIndex) {
            return attachToIndex(BatchAttachToIndexResponse.builder().applyMutation(attachToIndex).build());
        }

        /**
         * <p>
         * Detaches the specified object from the specified index.
         * </p>
         * 
         * @param detachFromIndex
         *        Detaches the specified object from the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachFromIndex(BatchDetachFromIndexResponse detachFromIndex);

        /**
         * <p>
         * Detaches the specified object from the specified index.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDetachFromIndexResponse.Builder}
         * avoiding the need to create one manually via {@link BatchDetachFromIndexResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDetachFromIndexResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #detachFromIndex(BatchDetachFromIndexResponse)}.
         * 
         * @param detachFromIndex
         *        a consumer that will call methods on {@link BatchDetachFromIndexResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachFromIndex(BatchDetachFromIndexResponse)
         */
        default Builder detachFromIndex(Consumer<BatchDetachFromIndexResponse.Builder> detachFromIndex) {
            return detachFromIndex(BatchDetachFromIndexResponse.builder().applyMutation(detachFromIndex).build());
        }

        /**
         * <p>
         * Attaches a typed link to a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param attachTypedLink
         *        Attaches a typed link to a specified source and target object. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTypedLink(BatchAttachTypedLinkResponse attachTypedLink);

        /**
         * <p>
         * Attaches a typed link to a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchAttachTypedLinkResponse.Builder}
         * avoiding the need to create one manually via {@link BatchAttachTypedLinkResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchAttachTypedLinkResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #attachTypedLink(BatchAttachTypedLinkResponse)}.
         * 
         * @param attachTypedLink
         *        a consumer that will call methods on {@link BatchAttachTypedLinkResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachTypedLink(BatchAttachTypedLinkResponse)
         */
        default Builder attachTypedLink(Consumer<BatchAttachTypedLinkResponse.Builder> attachTypedLink) {
            return attachTypedLink(BatchAttachTypedLinkResponse.builder().applyMutation(attachTypedLink).build());
        }

        /**
         * <p>
         * Detaches a typed link from a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param detachTypedLink
         *        Detaches a typed link from a specified source and target object. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachTypedLink(BatchDetachTypedLinkResponse detachTypedLink);

        /**
         * <p>
         * Detaches a typed link from a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDetachTypedLinkResponse.Builder}
         * avoiding the need to create one manually via {@link BatchDetachTypedLinkResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDetachTypedLinkResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #detachTypedLink(BatchDetachTypedLinkResponse)}.
         * 
         * @param detachTypedLink
         *        a consumer that will call methods on {@link BatchDetachTypedLinkResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachTypedLink(BatchDetachTypedLinkResponse)
         */
        default Builder detachTypedLink(Consumer<BatchDetachTypedLinkResponse.Builder> detachTypedLink) {
            return detachTypedLink(BatchDetachTypedLinkResponse.builder().applyMutation(detachTypedLink).build());
        }

        /**
         * <p>
         * Represents the output of a <code>BatchWrite</code> response operation.
         * </p>
         * 
         * @param updateLinkAttributes
         *        Represents the output of a <code>BatchWrite</code> response operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateLinkAttributes(BatchUpdateLinkAttributesResponse updateLinkAttributes);

        /**
         * <p>
         * Represents the output of a <code>BatchWrite</code> response operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchUpdateLinkAttributesResponse.Builder} avoiding the need to create one manually via
         * {@link BatchUpdateLinkAttributesResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchUpdateLinkAttributesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #updateLinkAttributes(BatchUpdateLinkAttributesResponse)}.
         * 
         * @param updateLinkAttributes
         *        a consumer that will call methods on {@link BatchUpdateLinkAttributesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateLinkAttributes(BatchUpdateLinkAttributesResponse)
         */
        default Builder updateLinkAttributes(Consumer<BatchUpdateLinkAttributesResponse.Builder> updateLinkAttributes) {
            return updateLinkAttributes(BatchUpdateLinkAttributesResponse.builder().applyMutation(updateLinkAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchCreateObjectResponse createObject;

        private BatchAttachObjectResponse attachObject;

        private BatchDetachObjectResponse detachObject;

        private BatchUpdateObjectAttributesResponse updateObjectAttributes;

        private BatchDeleteObjectResponse deleteObject;

        private BatchAddFacetToObjectResponse addFacetToObject;

        private BatchRemoveFacetFromObjectResponse removeFacetFromObject;

        private BatchAttachPolicyResponse attachPolicy;

        private BatchDetachPolicyResponse detachPolicy;

        private BatchCreateIndexResponse createIndex;

        private BatchAttachToIndexResponse attachToIndex;

        private BatchDetachFromIndexResponse detachFromIndex;

        private BatchAttachTypedLinkResponse attachTypedLink;

        private BatchDetachTypedLinkResponse detachTypedLink;

        private BatchUpdateLinkAttributesResponse updateLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperationResponse model) {
            createObject(model.createObject);
            attachObject(model.attachObject);
            detachObject(model.detachObject);
            updateObjectAttributes(model.updateObjectAttributes);
            deleteObject(model.deleteObject);
            addFacetToObject(model.addFacetToObject);
            removeFacetFromObject(model.removeFacetFromObject);
            attachPolicy(model.attachPolicy);
            detachPolicy(model.detachPolicy);
            createIndex(model.createIndex);
            attachToIndex(model.attachToIndex);
            detachFromIndex(model.detachFromIndex);
            attachTypedLink(model.attachTypedLink);
            detachTypedLink(model.detachTypedLink);
            updateLinkAttributes(model.updateLinkAttributes);
        }

        public final BatchCreateObjectResponse.Builder getCreateObject() {
            return createObject != null ? createObject.toBuilder() : null;
        }

        public final void setCreateObject(BatchCreateObjectResponse.BuilderImpl createObject) {
            this.createObject = createObject != null ? createObject.build() : null;
        }

        @Override
        public final Builder createObject(BatchCreateObjectResponse createObject) {
            this.createObject = createObject;
            return this;
        }

        public final BatchAttachObjectResponse.Builder getAttachObject() {
            return attachObject != null ? attachObject.toBuilder() : null;
        }

        public final void setAttachObject(BatchAttachObjectResponse.BuilderImpl attachObject) {
            this.attachObject = attachObject != null ? attachObject.build() : null;
        }

        @Override
        public final Builder attachObject(BatchAttachObjectResponse attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final BatchDetachObjectResponse.Builder getDetachObject() {
            return detachObject != null ? detachObject.toBuilder() : null;
        }

        public final void setDetachObject(BatchDetachObjectResponse.BuilderImpl detachObject) {
            this.detachObject = detachObject != null ? detachObject.build() : null;
        }

        @Override
        public final Builder detachObject(BatchDetachObjectResponse detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final BatchUpdateObjectAttributesResponse.Builder getUpdateObjectAttributes() {
            return updateObjectAttributes != null ? updateObjectAttributes.toBuilder() : null;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributesResponse.BuilderImpl updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes != null ? updateObjectAttributes.build() : null;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final BatchDeleteObjectResponse.Builder getDeleteObject() {
            return deleteObject != null ? deleteObject.toBuilder() : null;
        }

        public final void setDeleteObject(BatchDeleteObjectResponse.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObjectResponse deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final BatchAddFacetToObjectResponse.Builder getAddFacetToObject() {
            return addFacetToObject != null ? addFacetToObject.toBuilder() : null;
        }

        public final void setAddFacetToObject(BatchAddFacetToObjectResponse.BuilderImpl addFacetToObject) {
            this.addFacetToObject = addFacetToObject != null ? addFacetToObject.build() : null;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObjectResponse addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final BatchRemoveFacetFromObjectResponse.Builder getRemoveFacetFromObject() {
            return removeFacetFromObject != null ? removeFacetFromObject.toBuilder() : null;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObjectResponse.BuilderImpl removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject != null ? removeFacetFromObject.build() : null;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final BatchAttachPolicyResponse.Builder getAttachPolicy() {
            return attachPolicy != null ? attachPolicy.toBuilder() : null;
        }

        public final void setAttachPolicy(BatchAttachPolicyResponse.BuilderImpl attachPolicy) {
            this.attachPolicy = attachPolicy != null ? attachPolicy.build() : null;
        }

        @Override
        public final Builder attachPolicy(BatchAttachPolicyResponse attachPolicy) {
            this.attachPolicy = attachPolicy;
            return this;
        }

        public final BatchDetachPolicyResponse.Builder getDetachPolicy() {
            return detachPolicy != null ? detachPolicy.toBuilder() : null;
        }

        public final void setDetachPolicy(BatchDetachPolicyResponse.BuilderImpl detachPolicy) {
            this.detachPolicy = detachPolicy != null ? detachPolicy.build() : null;
        }

        @Override
        public final Builder detachPolicy(BatchDetachPolicyResponse detachPolicy) {
            this.detachPolicy = detachPolicy;
            return this;
        }

        public final BatchCreateIndexResponse.Builder getCreateIndex() {
            return createIndex != null ? createIndex.toBuilder() : null;
        }

        public final void setCreateIndex(BatchCreateIndexResponse.BuilderImpl createIndex) {
            this.createIndex = createIndex != null ? createIndex.build() : null;
        }

        @Override
        public final Builder createIndex(BatchCreateIndexResponse createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        public final BatchAttachToIndexResponse.Builder getAttachToIndex() {
            return attachToIndex != null ? attachToIndex.toBuilder() : null;
        }

        public final void setAttachToIndex(BatchAttachToIndexResponse.BuilderImpl attachToIndex) {
            this.attachToIndex = attachToIndex != null ? attachToIndex.build() : null;
        }

        @Override
        public final Builder attachToIndex(BatchAttachToIndexResponse attachToIndex) {
            this.attachToIndex = attachToIndex;
            return this;
        }

        public final BatchDetachFromIndexResponse.Builder getDetachFromIndex() {
            return detachFromIndex != null ? detachFromIndex.toBuilder() : null;
        }

        public final void setDetachFromIndex(BatchDetachFromIndexResponse.BuilderImpl detachFromIndex) {
            this.detachFromIndex = detachFromIndex != null ? detachFromIndex.build() : null;
        }

        @Override
        public final Builder detachFromIndex(BatchDetachFromIndexResponse detachFromIndex) {
            this.detachFromIndex = detachFromIndex;
            return this;
        }

        public final BatchAttachTypedLinkResponse.Builder getAttachTypedLink() {
            return attachTypedLink != null ? attachTypedLink.toBuilder() : null;
        }

        public final void setAttachTypedLink(BatchAttachTypedLinkResponse.BuilderImpl attachTypedLink) {
            this.attachTypedLink = attachTypedLink != null ? attachTypedLink.build() : null;
        }

        @Override
        public final Builder attachTypedLink(BatchAttachTypedLinkResponse attachTypedLink) {
            this.attachTypedLink = attachTypedLink;
            return this;
        }

        public final BatchDetachTypedLinkResponse.Builder getDetachTypedLink() {
            return detachTypedLink != null ? detachTypedLink.toBuilder() : null;
        }

        public final void setDetachTypedLink(BatchDetachTypedLinkResponse.BuilderImpl detachTypedLink) {
            this.detachTypedLink = detachTypedLink != null ? detachTypedLink.build() : null;
        }

        @Override
        public final Builder detachTypedLink(BatchDetachTypedLinkResponse detachTypedLink) {
            this.detachTypedLink = detachTypedLink;
            return this;
        }

        public final BatchUpdateLinkAttributesResponse.Builder getUpdateLinkAttributes() {
            return updateLinkAttributes != null ? updateLinkAttributes.toBuilder() : null;
        }

        public final void setUpdateLinkAttributes(BatchUpdateLinkAttributesResponse.BuilderImpl updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes != null ? updateLinkAttributes.build() : null;
        }

        @Override
        public final Builder updateLinkAttributes(BatchUpdateLinkAttributesResponse updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes;
            return this;
        }

        @Override
        public BatchWriteOperationResponse build() {
            return new BatchWriteOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
