/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data for a typed attribute. You can set one, and only one, of the elements. Each attribute in an item
 * is a name-value pair. Attributes have a single value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypedAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TypedAttributeValue.Builder, TypedAttributeValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(TypedAttributeValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final SdkField<SdkBytes> BINARY_VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("BinaryValue").getter(getter(TypedAttributeValue::binaryValue)).setter(setter(Builder::binaryValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BooleanValue").getter(getter(TypedAttributeValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()).build();

    private static final SdkField<String> NUMBER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberValue").getter(getter(TypedAttributeValue::numberValue)).setter(setter(Builder::numberValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()).build();

    private static final SdkField<Instant> DATETIME_VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DatetimeValue").getter(getter(TypedAttributeValue::datetimeValue))
            .setter(setter(Builder::datetimeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatetimeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            BINARY_VALUE_FIELD, BOOLEAN_VALUE_FIELD, NUMBER_VALUE_FIELD, DATETIME_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final SdkBytes binaryValue;

    private final Boolean booleanValue;

    private final String numberValue;

    private final Instant datetimeValue;

    private final Type type;

    private TypedAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
        this.booleanValue = builder.booleanValue;
        this.numberValue = builder.numberValue;
        this.datetimeValue = builder.datetimeValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * A string data value.
     * </p>
     * 
     * @return A string data value.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * A binary data value.
     * </p>
     * 
     * @return A binary data value.
     */
    public final SdkBytes binaryValue() {
        return binaryValue;
    }

    /**
     * <p>
     * A Boolean data value.
     * </p>
     * 
     * @return A Boolean data value.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * A number data value.
     * </p>
     * 
     * @return A number data value.
     */
    public final String numberValue() {
        return numberValue;
    }

    /**
     * <p>
     * A date and time value.
     * </p>
     * 
     * @return A date and time value.
     */
    public final Instant datetimeValue() {
        return datetimeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(binaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(datetimeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValue)) {
            return false;
        }
        TypedAttributeValue other = (TypedAttributeValue) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(binaryValue(), other.binaryValue())
                && Objects.equals(booleanValue(), other.booleanValue()) && Objects.equals(numberValue(), other.numberValue())
                && Objects.equals(datetimeValue(), other.datetimeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypedAttributeValue").add("StringValue", stringValue()).add("BinaryValue", binaryValue())
                .add("BooleanValue", booleanValue()).add("NumberValue", numberValue()).add("DatetimeValue", datetimeValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "BinaryValue":
            return Optional.ofNullable(clazz.cast(binaryValue()));
        case "BooleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "NumberValue":
            return Optional.ofNullable(clazz.cast(numberValue()));
        case "DatetimeValue":
            return Optional.ofNullable(clazz.cast(datetimeValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * A string data value.
     * </p>
     * 
     * @param stringValue
     *        A string data value.
     */
    public static TypedAttributeValue fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #binaryValue()} initialized to the given value.
     *
     * <p>
     * A binary data value.
     * </p>
     * 
     * @param binaryValue
     *        A binary data value.
     */
    public static TypedAttributeValue fromBinaryValue(SdkBytes binaryValue) {
        return builder().binaryValue(binaryValue).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * A Boolean data value.
     * </p>
     * 
     * @param booleanValue
     *        A Boolean data value.
     */
    public static TypedAttributeValue fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #numberValue()} initialized to the given value.
     *
     * <p>
     * A number data value.
     * </p>
     * 
     * @param numberValue
     *        A number data value.
     */
    public static TypedAttributeValue fromNumberValue(String numberValue) {
        return builder().numberValue(numberValue).build();
    }

    /**
     * Create an instance of this class with {@link #datetimeValue()} initialized to the given value.
     *
     * <p>
     * A date and time value.
     * </p>
     * 
     * @param datetimeValue
     *        A date and time value.
     */
    public static TypedAttributeValue fromDatetimeValue(Instant datetimeValue) {
        return builder().datetimeValue(datetimeValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringValue", STRING_VALUE_FIELD);
        map.put("BinaryValue", BINARY_VALUE_FIELD);
        map.put("BooleanValue", BOOLEAN_VALUE_FIELD);
        map.put("NumberValue", NUMBER_VALUE_FIELD);
        map.put("DatetimeValue", DATETIME_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypedAttributeValue, T> g) {
        return obj -> g.apply((TypedAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypedAttributeValue> {
        /**
         * <p>
         * A string data value.
         * </p>
         * 
         * @param stringValue
         *        A string data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * A binary data value.
         * </p>
         * 
         * @param binaryValue
         *        A binary data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryValue(SdkBytes binaryValue);

        /**
         * <p>
         * A Boolean data value.
         * </p>
         * 
         * @param booleanValue
         *        A Boolean data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * A number data value.
         * </p>
         * 
         * @param numberValue
         *        A number data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValue(String numberValue);

        /**
         * <p>
         * A date and time value.
         * </p>
         * 
         * @param datetimeValue
         *        A date and time value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datetimeValue(Instant datetimeValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private SdkBytes binaryValue;

        private Boolean booleanValue;

        private String numberValue;

        private Instant datetimeValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValue model) {
            stringValue(model.stringValue);
            binaryValue(model.binaryValue);
            booleanValue(model.booleanValue);
            numberValue(model.numberValue);
            datetimeValue(model.datetimeValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final ByteBuffer getBinaryValue() {
            return binaryValue == null ? null : binaryValue.asByteBuffer();
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            binaryValue(binaryValue == null ? null : SdkBytes.fromByteBuffer(binaryValue));
        }

        @Override
        public final Builder binaryValue(SdkBytes binaryValue) {
            Object oldValue = this.binaryValue;
            this.binaryValue = binaryValue;
            handleUnionValueChange(Type.BINARY_VALUE, oldValue, this.binaryValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final String getNumberValue() {
            return numberValue;
        }

        public final void setNumberValue(String numberValue) {
            Object oldValue = this.numberValue;
            this.numberValue = numberValue;
            handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
        }

        @Override
        public final Builder numberValue(String numberValue) {
            Object oldValue = this.numberValue;
            this.numberValue = numberValue;
            handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
            return this;
        }

        public final Instant getDatetimeValue() {
            return datetimeValue;
        }

        public final void setDatetimeValue(Instant datetimeValue) {
            Object oldValue = this.datetimeValue;
            this.datetimeValue = datetimeValue;
            handleUnionValueChange(Type.DATETIME_VALUE, oldValue, this.datetimeValue);
        }

        @Override
        public final Builder datetimeValue(Instant datetimeValue) {
            Object oldValue = this.datetimeValue;
            this.datetimeValue = datetimeValue;
            handleUnionValueChange(Type.DATETIME_VALUE, oldValue, this.datetimeValue);
            return this;
        }

        @Override
        public TypedAttributeValue build() {
            return new TypedAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TypedAttributeValue#type()
     */
    public enum Type {
        STRING_VALUE,

        BINARY_VALUE,

        BOOLEAN_VALUE,

        NUMBER_VALUE,

        DATETIME_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
