/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the range of attributes that are used by a specified filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypedLinkAttributeRange implements SdkPojo, Serializable,
        ToCopyableBuilder<TypedLinkAttributeRange.Builder, TypedLinkAttributeRange> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(TypedLinkAttributeRange::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<TypedAttributeValueRange> RANGE_FIELD = SdkField
            .<TypedAttributeValueRange> builder(MarshallingType.SDK_POJO).memberName("Range")
            .getter(getter(TypedLinkAttributeRange::range)).setter(setter(Builder::range))
            .constructor(TypedAttributeValueRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final TypedAttributeValueRange range;

    private TypedLinkAttributeRange(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.range = builder.range;
    }

    /**
     * <p>
     * The unique name of the typed link attribute.
     * </p>
     * 
     * @return The unique name of the typed link attribute.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The range of attribute values that are being selected.
     * </p>
     * 
     * @return The range of attribute values that are being selected.
     */
    public final TypedAttributeValueRange range() {
        return range;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkAttributeRange)) {
            return false;
        }
        TypedLinkAttributeRange other = (TypedLinkAttributeRange) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(range(), other.range());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypedLinkAttributeRange").add("AttributeName", attributeName()).add("Range", range()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Range", RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkAttributeRange, T> g) {
        return obj -> g.apply((TypedLinkAttributeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypedLinkAttributeRange> {
        /**
         * <p>
         * The unique name of the typed link attribute.
         * </p>
         * 
         * @param attributeName
         *        The unique name of the typed link attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The range of attribute values that are being selected.
         * </p>
         * 
         * @param range
         *        The range of attribute values that are being selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(TypedAttributeValueRange range);

        /**
         * <p>
         * The range of attribute values that are being selected.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedAttributeValueRange.Builder}
         * avoiding the need to create one manually via {@link TypedAttributeValueRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TypedAttributeValueRange.Builder#build()} is called immediately
         * and its result is passed to {@link #range(TypedAttributeValueRange)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link TypedAttributeValueRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(TypedAttributeValueRange)
         */
        default Builder range(Consumer<TypedAttributeValueRange.Builder> range) {
            return range(TypedAttributeValueRange.builder().applyMutation(range).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private TypedAttributeValueRange range;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkAttributeRange model) {
            attributeName(model.attributeName);
            range(model.range);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final TypedAttributeValueRange.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(TypedAttributeValueRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(TypedAttributeValueRange range) {
            this.range = range;
            return this;
        }

        @Override
        public TypedLinkAttributeRange build() {
            return new TypedLinkAttributeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
