/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>ListStacks</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStacksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListStacksRequest.Builder, ListStacksRequest> {
    private final String nextToken;

    private final List<String> stackStatusFilters;

    private ListStacksRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.stackStatusFilters = builder.stackStatusFilters;
    }

    /**
     * <p>
     * A string that identifies the next page of stacks that you want to retrieve.
     * </p>
     * 
     * @return A string that identifies the next page of stacks that you want to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified
     * status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the
     * <a>Stack</a> data type.
     * </p>
     * 
     * @return Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
     *         specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
     *         parameter of the <a>Stack</a> data type.
     * @see StackStatus
     */
    public List<String> stackStatusFilters() {
        return stackStatusFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((stackStatusFilters() == null) ? 0 : stackStatusFilters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksRequest)) {
            return false;
        }
        ListStacksRequest other = (ListStacksRequest) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.stackStatusFilters() == null ^ this.stackStatusFilters() == null) {
            return false;
        }
        if (other.stackStatusFilters() != null && !other.stackStatusFilters().equals(this.stackStatusFilters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (stackStatusFilters() != null) {
            sb.append("StackStatusFilters: ").append(stackStatusFilters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListStacksRequest> {
        /**
         * <p>
         * A string that identifies the next page of stacks that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of stacks that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatusFilters(Collection<String> stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStackStatusFilters(java.util.Collection)} or {@link #withStackStatusFilters(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatusFilters(String... stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStackStatusFilters(java.util.Collection)} or {@link #withStackStatusFilters(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatusFilters(StackStatus... stackStatusFilters);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<String> stackStatusFilters = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksRequest model) {
            setNextToken(model.nextToken);
            setStackStatusFilters(model.stackStatusFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getStackStatusFilters() {
            return stackStatusFilters;
        }

        @Override
        public final Builder stackStatusFilters(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFilters(String... stackStatusFilters) {
            if (this.stackStatusFilters == null) {
                this.stackStatusFilters = new SdkInternalList<>(stackStatusFilters.length);
            }
            for (String e : stackStatusFilters) {
                this.stackStatusFilters.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFilters(StackStatus... stackStatusFilters) {
            if (this.stackStatusFilters == null) {
                this.stackStatusFilters = new SdkInternalList<String>(stackStatusFilters.length);
            }
            for (StackStatus ele : stackStatusFilters) {
                this.stackStatusFilters.add(ele.toString());
            }
            return this;
        }

        public final void setStackStatusFilters(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
        }

        @SafeVarargs
        public final void setStackStatusFilters(String... stackStatusFilters) {
            if (this.stackStatusFilters == null) {
                this.stackStatusFilters = new SdkInternalList<>(stackStatusFilters.length);
            }
            for (String e : stackStatusFilters) {
                this.stackStatusFilters.add(e);
            }
        }

        @SafeVarargs
        public final void setStackStatusFilters(StackStatus... stackStatusFilters) {
            if (this.stackStatusFilters == null) {
                this.stackStatusFilters = new SdkInternalList<String>(stackStatusFilters.length);
            }
            for (StackStatus ele : stackStatusFilters) {
                this.stackStatusFilters.add(ele.toString());
            }
        }

        @Override
        public ListStacksRequest build() {
            return new ListStacksRequest(this);
        }
    }
}
