/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ResourceChange</code> structure describes the resource and the action that AWS CloudFormation will perform
 * on it if you execute this change set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceChange implements ToCopyableBuilder<ResourceChange.Builder, ResourceChange> {
    private final String action;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final String replacement;

    private final List<String> scope;

    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    /**
     * <p>
     * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * </p>
     * 
     * @return The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     *         <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * @see ChangeAction
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * The resource's logical ID, which is defined in the stack's template.
     * </p>
     * 
     * @return The resource's logical ID, which is defined in the stack's template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they
     * haven't been created.
     * </p>
     * 
     * @return The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because
     *         they haven't been created.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     * </p>
     * 
     * @return The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a
     * new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property
     * in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field
     * is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is
     * <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the
     * <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.
     * </p>
     * <p>
     * If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code>
     * value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code>
     * has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
     *         creating a new one and deleting the old one. This value depends on the value of the
     *         <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
     *         example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
     *         <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If
     *         the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
     *         <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
     *         <p>
     *         If you have multiple changes with different <code>RequiresRecreation</code> values, the
     *         <code>Replacement</code> value depends on the change with the most impact. A
     *         <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
     *         <code>Conditionally</code>, and then <code>Never</code>.
     * @see Replacement
     */
    public String replacement() {
        return replacement;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
     * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as
     *         a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>
     *         .
     * @see ResourceAttribute
     */
    public List<String> scope() {
        return scope;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
     * changes that AWS CloudFormation will make to the resource.
     * </p>
     * 
     * @return For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes
     *         the changes that AWS CloudFormation will make to the resource.
     */
    public List<ResourceChangeDetail> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((action() == null) ? 0 : action().hashCode());
        hashCode = 31 * hashCode + ((logicalResourceId() == null) ? 0 : logicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((physicalResourceId() == null) ? 0 : physicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((replacement() == null) ? 0 : replacement().hashCode());
        hashCode = 31 * hashCode + ((scope() == null) ? 0 : scope().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange) obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.replacement() == null ^ this.replacement() == null) {
            return false;
        }
        if (other.replacement() != null && !other.replacement().equals(this.replacement())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (action() != null) {
            sb.append("Action: ").append(action()).append(",");
        }
        if (logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(logicalResourceId()).append(",");
        }
        if (physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(physicalResourceId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (replacement() != null) {
            sb.append("Replacement: ").append(replacement()).append(",");
        }
        if (scope() != null) {
            sb.append("Scope: ").append(scope()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceChange> {
        /**
         * <p>
         * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
         * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * </p>
         * 
         * @param action
         *        The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new
         *        resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
         * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * </p>
         * 
         * @param action
         *        The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new
         *        resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The resource's logical ID, which is defined in the stack's template.
         * </p>
         * 
         * @param logicalResourceId
         *        The resource's logical ID, which is defined in the stack's template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because
         * they haven't been created.
         * </p>
         * 
         * @param physicalResourceId
         *        The resource's physical ID (resource name). Resources that you are adding don't have physical IDs
         *        because they haven't been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         * creating a new one and deleting the old one. This value depends on the value of the
         * <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example,
         * if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
         * <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code>
         * field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>,
         * <code>Replacement</code> is <code>Conditionally</code>.
         * </p>
         * <p>
         * If you have multiple changes with different <code>RequiresRecreation</code> values, the
         * <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code>
         * value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then
         * <code>Never</code>.
         * </p>
         * 
         * @param replacement
         *        For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         *        creating a new one and deleting the old one. This value depends on the value of the
         *        <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
         *        example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
         *        <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>.
         *        If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code>
         *        field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
         *        <p>
         *        If you have multiple changes with different <code>RequiresRecreation</code> values, the
         *        <code>Replacement</code> value depends on the change with the most impact. A
         *        <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
         *        <code>Conditionally</code>, and then <code>Never</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(String replacement);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         * creating a new one and deleting the old one. This value depends on the value of the
         * <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example,
         * if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
         * <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code>
         * field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>,
         * <code>Replacement</code> is <code>Conditionally</code>.
         * </p>
         * <p>
         * If you have multiple changes with different <code>RequiresRecreation</code> values, the
         * <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code>
         * value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then
         * <code>Never</code>.
         * </p>
         * 
         * @param replacement
         *        For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         *        creating a new one and deleting the old one. This value depends on the value of the
         *        <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
         *        example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
         *        <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>.
         *        If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code>
         *        field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
         *        <p>
         *        If you have multiple changes with different <code>RequiresRecreation</code> values, the
         *        <code>Replacement</code> value depends on the change with the most impact. A
         *        <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
         *        <code>Conditionally</code>, and then <code>Never</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(Replacement replacement);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder scope(Collection<String> scope);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setScope(java.util.Collection)} or {@link #withScope(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder scope(String... scope);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setScope(java.util.Collection)} or {@link #withScope(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder scope(ResourceAttribute... scope);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * 
         * @param details
         *        For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that
         *        describes the changes that AWS CloudFormation will make to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<ResourceChangeDetail> details);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDetails(java.util.Collection)} or {@link #withDetails(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param details
         *        For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that
         *        describes the changes that AWS CloudFormation will make to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResourceChangeDetail... details);
    }

    private static final class BuilderImpl implements Builder {
        private String action;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private String replacement;

        private List<String> scope = new SdkInternalList<>();

        private List<ResourceChangeDetail> details = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            setAction(model.action);
            setLogicalResourceId(model.logicalResourceId);
            setPhysicalResourceId(model.physicalResourceId);
            setResourceType(model.resourceType);
            setReplacement(model.replacement);
            setScope(model.scope);
            setDetails(model.details);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ChangeAction action) {
            this.action(action.toString());
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getReplacement() {
            return replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement.toString());
            return this;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public final void setReplacement(Replacement replacement) {
            this.replacement(replacement.toString());
        }

        public final Collection<String> getScope() {
            return scope;
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList<>(scope.length);
            }
            for (String e : scope) {
                this.scope.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(ResourceAttribute... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList<String>(scope.length);
            }
            for (ResourceAttribute ele : scope) {
                this.scope.add(ele.toString());
            }
            return this;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        @SafeVarargs
        public final void setScope(String... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList<>(scope.length);
            }
            for (String e : scope) {
                this.scope.add(e);
            }
        }

        @SafeVarargs
        public final void setScope(ResourceAttribute... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList<String>(scope.length);
            }
            for (ResourceAttribute ele : scope) {
                this.scope.add(ele.toString());
            }
        }

        public final Collection<ResourceChangeDetail> getDetails() {
            return details;
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail... details) {
            if (this.details == null) {
                this.details = new SdkInternalList<>(details.length);
            }
            for (ResourceChangeDetail e : details) {
                this.details.add(e);
            }
            return this;
        }

        public final void setDetails(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
        }

        @SafeVarargs
        public final void setDetails(ResourceChangeDetail... details) {
            if (this.details == null) {
                this.details = new SdkInternalList<>(details.length);
            }
            for (ResourceChangeDetail e : details) {
                this.details.add(e);
            }
        }

        @Override
        public ResourceChange build() {
            return new ResourceChange(this);
        }
    }
}
