/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field that AWS CloudFormation will change, such as the name of a resource's property, and whether the resource
 * will be recreated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceTargetDefinition implements ToCopyableBuilder<ResourceTargetDefinition.Builder, ResourceTargetDefinition> {
    private final String attribute;

    private final String name;

    private final String requiresRecreation;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
    }

    /**
     * <p>
     * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
     * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * 
     * @return Indicates which resource attribute is triggering this update, such as a change in the resource
     *         attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * @see ResourceAttribute
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
     * attributes, the value is null.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
     *         attributes, the value is null.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
     * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
     * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
     * update behavior for that <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     * >property</a> in the AWS CloudFormation User Guide.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
     *         property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>,
     *         or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation,
     *         see the update behavior for that <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >property</a> in the AWS CloudFormation User Guide.
     * @see RequiresRecreation
     */
    public String requiresRecreation() {
        return requiresRecreation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((requiresRecreation() == null) ? 0 : requiresRecreation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.requiresRecreation() == null ^ this.requiresRecreation() == null) {
            return false;
        }
        if (other.requiresRecreation() != null && !other.requiresRecreation().equals(this.requiresRecreation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (requiresRecreation() != null) {
            sb.append("RequiresRecreation: ").append(requiresRecreation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceTargetDefinition> {
        /**
         * <p>
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
         * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param attribute
         *        Indicates which resource attribute is triggering this update, such as a change in the resource
         *        attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
         * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param attribute
         *        Indicates which resource attribute is triggering this update, such as a change in the resource
         *        attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(ResourceAttribute attribute);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
         * attributes, the value is null.
         * </p>
         * 
         * @param name
         *        If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all
         *        other attributes, the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
         * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
         * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
         * update behavior for that <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >property</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param requiresRecreation
         *        If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
         *        property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>
         *        , or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code>
         *        recreation, see the update behavior for that <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >property</a> in the AWS CloudFormation User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(String requiresRecreation);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
         * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
         * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
         * update behavior for that <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >property</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param requiresRecreation
         *        If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
         *        property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>
         *        , or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code>
         *        recreation, see the update behavior for that <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >property</a> in the AWS CloudFormation User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(RequiresRecreation requiresRecreation);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private String name;

        private String requiresRecreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            setAttribute(model.attribute);
            setName(model.name);
            setRequiresRecreation(model.requiresRecreation);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final void setAttribute(ResourceAttribute attribute) {
            this.attribute(attribute.toString());
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequiresRecreation() {
            return requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation.toString());
            return this;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        public final void setRequiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation.toString());
        }

        @Override
        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }
    }
}
