/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The StackEvent data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackEvent implements ToCopyableBuilder<StackEvent.Builder, StackEvent> {
    private final String stackId;

    private final String eventId;

    private final String stackName;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final Date timestamp;

    private final String resourceStatus;

    private final String resourceStatusReason;

    private final String resourceProperties;

    private final String clientRequestToken;

    private StackEvent(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.eventId = builder.eventId;
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The unique ID name of the instance of the stack.
     * </p>
     * 
     * @return The unique ID name of the instance of the stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The unique ID of this event.
     * </p>
     * 
     * @return The unique ID of this event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The name associated with a stack.
     * </p>
     * 
     * @return The name associated with a stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical name of the resource specified in the template.
     * </p>
     * 
     * @return The logical name of the resource specified in the template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier associated with the physical instance of the resource.
     * </p>
     * 
     * @return The name or unique identifier associated with the physical instance of the resource.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Type of resource. (For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS
     * Resource Types Reference</a> in the AWS CloudFormation User Guide.)
     * </p>
     * 
     * @return Type of resource. (For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
     *         AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Time the status was updated.
     * </p>
     * 
     * @return Time the status was updated.
     */
    public Date timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public String resourceStatus() {
        return resourceStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the resource.
     * </p>
     * 
     * @return Success/failure message associated with the resource.
     */
    public String resourceStatusReason() {
        return resourceStatusReason;
    }

    /**
     * <p>
     * BLOB of the properties used to create the resource.
     * </p>
     * 
     * @return BLOB of the properties used to create the resource.
     */
    public String resourceProperties() {
        return resourceProperties;
    }

    /**
     * <p>
     * The token passed to the operation that generated this event.
     * </p>
     * <p>
     * For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the
     * <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as
     * <code>token1</code>.
     * </p>
     * 
     * @return The token passed to the operation that generated this event.</p>
     *         <p>
     *         For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then
     *         all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code>
     *         set as <code>token1</code>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((eventId() == null) ? 0 : eventId().hashCode());
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((logicalResourceId() == null) ? 0 : logicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((physicalResourceId() == null) ? 0 : physicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((resourceStatus() == null) ? 0 : resourceStatus().hashCode());
        hashCode = 31 * hashCode + ((resourceStatusReason() == null) ? 0 : resourceStatusReason().hashCode());
        hashCode = 31 * hashCode + ((resourceProperties() == null) ? 0 : resourceProperties().hashCode());
        hashCode = 31 * hashCode + ((clientRequestToken() == null) ? 0 : clientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackEvent)) {
            return false;
        }
        StackEvent other = (StackEvent) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.resourceStatus() == null ^ this.resourceStatus() == null) {
            return false;
        }
        if (other.resourceStatus() != null && !other.resourceStatus().equals(this.resourceStatus())) {
            return false;
        }
        if (other.resourceStatusReason() == null ^ this.resourceStatusReason() == null) {
            return false;
        }
        if (other.resourceStatusReason() != null && !other.resourceStatusReason().equals(this.resourceStatusReason())) {
            return false;
        }
        if (other.resourceProperties() == null ^ this.resourceProperties() == null) {
            return false;
        }
        if (other.resourceProperties() != null && !other.resourceProperties().equals(this.resourceProperties())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        if (other.clientRequestToken() != null && !other.clientRequestToken().equals(this.clientRequestToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(logicalResourceId()).append(",");
        }
        if (physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(physicalResourceId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (resourceStatus() != null) {
            sb.append("ResourceStatus: ").append(resourceStatus()).append(",");
        }
        if (resourceStatusReason() != null) {
            sb.append("ResourceStatusReason: ").append(resourceStatusReason()).append(",");
        }
        if (resourceProperties() != null) {
            sb.append("ResourceProperties: ").append(resourceProperties()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StackEvent> {
        /**
         * <p>
         * The unique ID name of the instance of the stack.
         * </p>
         * 
         * @param stackId
         *        The unique ID name of the instance of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The unique ID of this event.
         * </p>
         * 
         * @param eventId
         *        The unique ID of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The name associated with a stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with a stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical name of the resource specified in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource specified in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier associated with the physical instance of the resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier associated with the physical instance of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * Type of resource. (For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS
         * Resource Types Reference</a> in the AWS CloudFormation User Guide.)
         * </p>
         * 
         * @param resourceType
         *        Type of resource. (For more information, go to <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
         *        AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Time the status was updated.
         * </p>
         * 
         * @param timestamp
         *        Time the status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Date timestamp);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Success/failure message associated with the resource.
         * </p>
         * 
         * @param resourceStatusReason
         *        Success/failure message associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatusReason(String resourceStatusReason);

        /**
         * <p>
         * BLOB of the properties used to create the resource.
         * </p>
         * 
         * @param resourceProperties
         *        BLOB of the properties used to create the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceProperties(String resourceProperties);

        /**
         * <p>
         * The token passed to the operation that generated this event.
         * </p>
         * <p>
         * For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all
         * the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as
         * <code>token1</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        The token passed to the operation that generated this event.</p>
         *        <p>
         *        For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>,
         *        then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private String eventId;

        private String stackName;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private Date timestamp;

        private String resourceStatus;

        private String resourceStatusReason;

        private String resourceProperties;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StackEvent model) {
            setStackId(model.stackId);
            setEventId(model.eventId);
            setStackName(model.stackName);
            setLogicalResourceId(model.logicalResourceId);
            setPhysicalResourceId(model.physicalResourceId);
            setResourceType(model.resourceType);
            setTimestamp(model.timestamp);
            setResourceStatus(model.resourceStatus);
            setResourceStatusReason(model.resourceStatusReason);
            setResourceProperties(model.resourceProperties);
            setClientRequestToken(model.clientRequestToken);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Date getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final void setResourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
        }

        public final String getResourceStatusReason() {
            return resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public final String getResourceProperties() {
            return resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public StackEvent build() {
            return new StackEvent(this);
        }
    }
}
