/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The StackSummary Data Type
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackSummary implements ToCopyableBuilder<StackSummary.Builder, StackSummary> {
    private final String stackId;

    private final String stackName;

    private final String templateDescription;

    private final Date creationTime;

    private final Date lastUpdatedTime;

    private final Date deletionTime;

    private final String stackStatus;

    private final String stackStatusReason;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.templateDescription = builder.templateDescription;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
    }

    /**
     * <p>
     * Unique stack identifier.
     * </p>
     * 
     * @return Unique stack identifier.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The template description of the template used to create the stack.
     * </p>
     * 
     * @return The template description of the template used to create the stack.
     */
    public String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The time the stack was created.
     * </p>
     * 
     * @return The time the stack was created.
     */
    public Date creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least
     * once.
     * </p>
     * 
     * @return The time the stack was last updated. This field will only be returned if the stack has been updated at
     *         least once.
     */
    public Date lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The time the stack was deleted.
     * </p>
     * 
     * @return The time the stack was deleted.
     */
    public Date deletionTime() {
        return deletionTime;
    }

    /**
     * <p>
     * The current status of the stack.
     * </p>
     * 
     * @return The current status of the stack.
     * @see StackStatus
     */
    public String stackStatus() {
        return stackStatus;
    }

    /**
     * <p>
     * Success/Failure message associated with the stack status.
     * </p>
     * 
     * @return Success/Failure message associated with the stack status.
     */
    public String stackStatusReason() {
        return stackStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((templateDescription() == null) ? 0 : templateDescription().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedTime() == null) ? 0 : lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + ((deletionTime() == null) ? 0 : deletionTime().hashCode());
        hashCode = 31 * hashCode + ((stackStatus() == null) ? 0 : stackStatus().hashCode());
        hashCode = 31 * hashCode + ((stackStatusReason() == null) ? 0 : stackStatusReason().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.templateDescription() == null ^ this.templateDescription() == null) {
            return false;
        }
        if (other.templateDescription() != null && !other.templateDescription().equals(this.templateDescription())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.deletionTime() == null ^ this.deletionTime() == null) {
            return false;
        }
        if (other.deletionTime() != null && !other.deletionTime().equals(this.deletionTime())) {
            return false;
        }
        if (other.stackStatus() == null ^ this.stackStatus() == null) {
            return false;
        }
        if (other.stackStatus() != null && !other.stackStatus().equals(this.stackStatus())) {
            return false;
        }
        if (other.stackStatusReason() == null ^ this.stackStatusReason() == null) {
            return false;
        }
        if (other.stackStatusReason() != null && !other.stackStatusReason().equals(this.stackStatusReason())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (templateDescription() != null) {
            sb.append("TemplateDescription: ").append(templateDescription()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(lastUpdatedTime()).append(",");
        }
        if (deletionTime() != null) {
            sb.append("DeletionTime: ").append(deletionTime()).append(",");
        }
        if (stackStatus() != null) {
            sb.append("StackStatus: ").append(stackStatus()).append(",");
        }
        if (stackStatusReason() != null) {
            sb.append("StackStatusReason: ").append(stackStatusReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StackSummary> {
        /**
         * <p>
         * Unique stack identifier.
         * </p>
         * 
         * @param stackId
         *        Unique stack identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The template description of the template used to create the stack.
         * </p>
         * 
         * @param templateDescription
         *        The template description of the template used to create the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The time the stack was created.
         * </p>
         * 
         * @param creationTime
         *        The time the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Date creationTime);

        /**
         * <p>
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least
         * once.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the stack was last updated. This field will only be returned if the stack has been updated at
         *        least once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Date lastUpdatedTime);

        /**
         * <p>
         * The time the stack was deleted.
         * </p>
         * 
         * @param deletionTime
         *        The time the stack was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionTime(Date deletionTime);

        /**
         * <p>
         * The current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        The current status of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(String stackStatus);

        /**
         * <p>
         * The current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        The current status of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(StackStatus stackStatus);

        /**
         * <p>
         * Success/Failure message associated with the stack status.
         * </p>
         * 
         * @param stackStatusReason
         *        Success/Failure message associated with the stack status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusReason(String stackStatusReason);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private String stackName;

        private String templateDescription;

        private Date creationTime;

        private Date lastUpdatedTime;

        private Date deletionTime;

        private String stackStatus;

        private String stackStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            setStackId(model.stackId);
            setStackName(model.stackName);
            setTemplateDescription(model.templateDescription);
            setCreationTime(model.creationTime);
            setLastUpdatedTime(model.lastUpdatedTime);
            setDeletionTime(model.deletionTime);
            setStackStatus(model.stackStatus);
            setStackStatusReason(model.stackStatusReason);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final Date getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy(creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy(creationTime);
        }

        public final Date getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = StandardMemberCopier.copy(lastUpdatedTime);
            return this;
        }

        public final void setLastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = StandardMemberCopier.copy(lastUpdatedTime);
        }

        public final Date getDeletionTime() {
            return deletionTime;
        }

        @Override
        public final Builder deletionTime(Date deletionTime) {
            this.deletionTime = StandardMemberCopier.copy(deletionTime);
            return this;
        }

        public final void setDeletionTime(Date deletionTime) {
            this.deletionTime = StandardMemberCopier.copy(deletionTime);
        }

        public final String getStackStatus() {
            return stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final void setStackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
        }

        public final String getStackStatusReason() {
            return stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        @Override
        public StackSummary build() {
            return new StackSummary(this);
        }
    }
}
