/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DeleteStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteStackRequestMarshaller implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {

    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {

        if (deleteStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteStackRequest> request = new DefaultRequest<DeleteStackRequest>(deleteStackRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (deleteStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(deleteStackRequest.stackName()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> retainResourcesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) deleteStackRequest
                .retainResources();
        if (retainResourcesList.isEmpty() && !retainResourcesList.isAutoConstruct()) {
            request.addParameter("RetainResources", "");
        }
        if (!retainResourcesList.isEmpty() || !retainResourcesList.isAutoConstruct()) {
            int retainResourcesListIndex = 1;

            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex,
                            StringUtils.fromString(retainResourcesListValue));
                }
                retainResourcesListIndex++;
            }
        }

        if (deleteStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(deleteStackRequest.roleARN()));
        }

        if (deleteStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(deleteStackRequest.clientRequestToken()));
        }

        return request;
    }

}
