/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * UpdateStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateStackRequestMarshaller implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {

    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {

        if (updateStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UpdateStackRequest> request = new DefaultRequest<UpdateStackRequest>(updateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(updateStackRequest.stackName()));
        }

        if (updateStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString(updateStackRequest.templateBody()));
        }

        if (updateStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString(updateStackRequest.templateURL()));
        }

        if (updateStackRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean(updateStackRequest.usePreviousTemplate()));
        }

        if (updateStackRequest.stackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody",
                    StringUtils.fromString(updateStackRequest.stackPolicyDuringUpdateBody()));
        }

        if (updateStackRequest.stackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL",
                    StringUtils.fromString(updateStackRequest.stackPolicyDuringUpdateURL()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<Parameter> parametersList = (software.amazon.awssdk.runtime.SdkInternalList<Parameter>) updateStackRequest
                .parameters();
        if (parametersList.isEmpty() && !parametersList.isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!parametersList.isEmpty() || !parametersList.isAutoConstruct()) {
            int parametersListIndex = 1;

            for (Parameter parametersListValue : parametersList) {

                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                            StringUtils.fromString(parametersListValue.parameterKey()));
                }

                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                            StringUtils.fromString(parametersListValue.parameterValue()));
                }

                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                            StringUtils.fromBoolean(parametersListValue.usePreviousValue()));
                }
                parametersListIndex++;
            }
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> capabilitiesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) updateStackRequest
                .capabilities();
        if (capabilitiesList.isEmpty() && !capabilitiesList.isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!capabilitiesList.isEmpty() || !capabilitiesList.isAutoConstruct()) {
            int capabilitiesListIndex = 1;

            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex,
                            StringUtils.fromString(capabilitiesListValue));
                }
                capabilitiesListIndex++;
            }
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> resourceTypesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) updateStackRequest
                .resourceTypes();
        if (resourceTypesList.isEmpty() && !resourceTypesList.isAutoConstruct()) {
            request.addParameter("ResourceTypes", "");
        }
        if (!resourceTypesList.isEmpty() || !resourceTypesList.isAutoConstruct()) {
            int resourceTypesListIndex = 1;

            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex,
                            StringUtils.fromString(resourceTypesListValue));
                }
                resourceTypesListIndex++;
            }
        }

        if (updateStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(updateStackRequest.roleARN()));
        }

        if (updateStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString(updateStackRequest.stackPolicyBody()));
        }

        if (updateStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString(updateStackRequest.stackPolicyURL()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> notificationARNsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) updateStackRequest
                .notificationARNs();
        if (notificationARNsList.isEmpty() && !notificationARNsList.isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        if (!notificationARNsList.isEmpty() || !notificationARNsList.isAutoConstruct()) {
            int notificationARNsListIndex = 1;

            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex,
                            StringUtils.fromString(notificationARNsListValue));
                }
                notificationARNsListIndex++;
            }
        }

        software.amazon.awssdk.runtime.SdkInternalList<Tag> tagsList = (software.amazon.awssdk.runtime.SdkInternalList<Tag>) updateStackRequest
                .tags();
        if (tagsList.isEmpty() && !tagsList.isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (updateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(updateStackRequest.clientRequestToken()));
        }

        return request;
    }

}
