/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.Change;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus;
import software.amazon.awssdk.services.cloudformation.model.ChangesCopier;
import software.amazon.awssdk.services.cloudformation.model.ExecutionStatus;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeChangeSetResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeChangeSetResponse> {
    private final String changeSetName;
    private final String changeSetId;
    private final String stackId;
    private final String stackName;
    private final String description;
    private final List<Parameter> parameters;
    private final Date creationTime;
    private final String executionStatus;
    private final String status;
    private final String statusReason;
    private final List<String> notificationARNs;
    private final List<String> capabilities;
    private final List<Tag> tags;
    private final List<Change> changes;
    private final String nextToken;

    private DescribeChangeSetResponse(BuilderImpl builder) {
        this.changeSetName = builder.changeSetName;
        this.changeSetId = builder.changeSetId;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.notificationARNs = builder.notificationARNs;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.changes = builder.changes;
        this.nextToken = builder.nextToken;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String description() {
        return this.description;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public String executionStatus() {
        return this.executionStatus;
    }

    public String status() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<Change> changes() {
        return this.changes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.changeSetName() == null ? 0 : this.changeSetName().hashCode());
        hashCode = 31 * hashCode + (this.changeSetId() == null ? 0 : this.changeSetId().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.executionStatus() == null ? 0 : this.executionStatus().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.notificationARNs() == null ? 0 : this.notificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.capabilities() == null ? 0 : this.capabilities().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.changes() == null ? 0 : this.changes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetResponse)) {
            return false;
        }
        DescribeChangeSetResponse other = (DescribeChangeSetResponse)((Object)obj);
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.changeSetId() == null ^ this.changeSetId() == null) {
            return false;
        }
        if (other.changeSetId() != null && !other.changeSetId().equals(this.changeSetId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.executionStatus() == null ^ this.executionStatus() == null) {
            return false;
        }
        if (other.executionStatus() != null && !other.executionStatus().equals(this.executionStatus())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.changes() == null ^ this.changes() == null) {
            return false;
        }
        if (other.changes() != null && !other.changes().equals(this.changes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.changeSetId() != null) {
            sb.append("ChangeSetId: ").append(this.changeSetId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.executionStatus() != null) {
            sb.append("ExecutionStatus: ").append(this.executionStatus()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.capabilities() != null) {
            sb.append("Capabilities: ").append(this.capabilities()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.changes() != null) {
            sb.append("Changes: ").append(this.changes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String changeSetName;
        private String changeSetId;
        private String stackId;
        private String stackName;
        private String description;
        private List<Parameter> parameters = new SdkInternalList();
        private Date creationTime;
        private String executionStatus;
        private String status;
        private String statusReason;
        private List<String> notificationARNs = new SdkInternalList();
        private List<String> capabilities = new SdkInternalList();
        private List<Tag> tags = new SdkInternalList();
        private List<Change> changes = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetResponse model) {
            this.setChangeSetName(model.changeSetName);
            this.setChangeSetId(model.changeSetId);
            this.setStackId(model.stackId);
            this.setStackName(model.stackName);
            this.setDescription(model.description);
            this.setParameters(model.parameters);
            this.setCreationTime(model.creationTime);
            this.setExecutionStatus(model.executionStatus);
            this.setStatus(model.status);
            this.setStatusReason(model.statusReason);
            this.setNotificationARNs(model.notificationARNs);
            this.setCapabilities(model.capabilities);
            this.setTags(model.tags);
            this.setChanges(model.changes);
            this.setNextToken(model.nextToken);
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final void setExecutionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ChangeSetStatus status) {
            this.status(status.toString());
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            if (this.notificationARNs == null) {
                this.notificationARNs = new SdkInternalList(notificationARNs.length);
            }
            for (String e : notificationARNs) {
                this.notificationARNs.add(e);
            }
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @SafeVarargs
        public final void setNotificationARNs(String ... notificationARNs) {
            if (this.notificationARNs == null) {
                this.notificationARNs = new SdkInternalList(notificationARNs.length);
            }
            for (String e : notificationARNs) {
                this.notificationARNs.add(e);
            }
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (String e : capabilities) {
                this.capabilities.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (Capability ele : capabilities) {
                this.capabilities.add(ele.toString());
            }
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @SafeVarargs
        public final void setCapabilities(String ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (String e : capabilities) {
                this.capabilities.add(e);
            }
        }

        @SafeVarargs
        public final void setCapabilities(Capability ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (Capability ele : capabilities) {
                this.capabilities.add(ele.toString());
            }
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final Collection<Change> getChanges() {
            return this.changes;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change ... changes) {
            if (this.changes == null) {
                this.changes = new SdkInternalList(changes.length);
            }
            for (Change e : changes) {
                this.changes.add(e);
            }
            return this;
        }

        public final void setChanges(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
        }

        @SafeVarargs
        public final void setChanges(Change ... changes) {
            if (this.changes == null) {
                this.changes = new SdkInternalList(changes.length);
            }
            for (Change e : changes) {
                this.changes.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeChangeSetResponse build() {
            return new DescribeChangeSetResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeChangeSetResponse> {
        public Builder changeSetName(String var1);

        public Builder changeSetId(String var1);

        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder creationTime(Date var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder status(String var1);

        public Builder status(ChangeSetStatus var1);

        public Builder statusReason(String var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilities(Capability ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder changes(Collection<Change> var1);

        public Builder changes(Change ... var1);

        public Builder nextToken(String var1);
    }
}

