/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EstimateTemplateCostRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, EstimateTemplateCostRequest> {
    private final String templateBody;
    private final String templateURL;
    private final List<Parameter> parameters;

    private EstimateTemplateCostRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimateTemplateCostRequest)) {
            return false;
        }
        EstimateTemplateCostRequest other = (EstimateTemplateCostRequest)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"EstimateTemplateCostRequest").add("TemplateBody", (Object)this.templateBody()).add("TemplateURL", (Object)this.templateURL()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.of(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.of(clazz.cast(this.templateURL()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String templateBody;
        private String templateURL;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimateTemplateCostRequest model) {
            super(model);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.parameters(model.parameters);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EstimateTemplateCostRequest build() {
            return new EstimateTemplateCostRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, EstimateTemplateCostRequest> {
        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

