/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSetOperation
implements ToCopyableBuilder<Builder, StackSetOperation> {
    private final String operationId;
    private final String stackSetId;
    private final String action;
    private final String status;
    private final StackSetOperationPreferences operationPreferences;
    private final Boolean retainStacks;
    private final Instant creationTimestamp;
    private final Instant endTimestamp;

    private StackSetOperation(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.stackSetId = builder.stackSetId;
        this.action = builder.action;
        this.status = builder.status;
        this.operationPreferences = builder.operationPreferences;
        this.retainStacks = builder.retainStacks;
        this.creationTimestamp = builder.creationTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    public String operationId() {
        return this.operationId;
    }

    public String stackSetId() {
        return this.stackSetId;
    }

    public StackSetOperationAction action() {
        return StackSetOperationAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public StackSetOperationStatus status() {
        return StackSetOperationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public StackSetOperationPreferences operationPreferences() {
        return this.operationPreferences;
    }

    public Boolean retainStacks() {
        return this.retainStacks;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Instant endTimestamp() {
        return this.endTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainStacks());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperation)) {
            return false;
        }
        StackSetOperation other = (StackSetOperation)obj;
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.operationPreferences(), other.operationPreferences()) && Objects.equals(this.retainStacks(), other.retainStacks()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"StackSetOperation").add("OperationId", (Object)this.operationId()).add("StackSetId", (Object)this.stackSetId()).add("Action", (Object)this.actionAsString()).add("Status", (Object)this.statusAsString()).add("OperationPreferences", (Object)this.operationPreferences()).add("RetainStacks", (Object)this.retainStacks()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.of(clazz.cast(this.operationId()));
            }
            case "StackSetId": {
                return Optional.of(clazz.cast(this.stackSetId()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.actionAsString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "OperationPreferences": {
                return Optional.of(clazz.cast(this.operationPreferences()));
            }
            case "RetainStacks": {
                return Optional.of(clazz.cast(this.retainStacks()));
            }
            case "CreationTimestamp": {
                return Optional.of(clazz.cast(this.creationTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.of(clazz.cast(this.endTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private String stackSetId;
        private String action;
        private String status;
        private StackSetOperationPreferences operationPreferences;
        private Boolean retainStacks;
        private Instant creationTimestamp;
        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperation model) {
            this.operationId(model.operationId);
            this.stackSetId(model.stackSetId);
            this.action(model.action);
            this.status(model.status);
            this.operationPreferences(model.operationPreferences);
            this.retainStacks(model.retainStacks);
            this.creationTimestamp(model.creationTimestamp);
            this.endTimestamp(model.endTimestamp);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(StackSetOperationAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return this.operationPreferences != null ? this.operationPreferences.toBuilder() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        public final Boolean getRetainStacks() {
            return this.retainStacks;
        }

        @Override
        public final Builder retainStacks(Boolean retainStacks) {
            this.retainStacks = retainStacks;
            return this;
        }

        public final void setRetainStacks(Boolean retainStacks) {
            this.retainStacks = retainStacks;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public StackSetOperation build() {
            return new StackSetOperation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSetOperation> {
        public Builder operationId(String var1);

        public Builder stackSetId(String var1);

        public Builder action(String var1);

        public Builder action(StackSetOperationAction var1);

        public Builder status(String var1);

        public Builder status(StackSetOperationStatus var1);

        public Builder operationPreferences(StackSetOperationPreferences var1);

        default public Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return this.operationPreferences((StackSetOperationPreferences)((StackSetOperationPreferences.Builder)StackSetOperationPreferences.builder().apply(operationPreferences)).build());
        }

        public Builder retainStacks(Boolean var1);

        public Builder creationTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);
    }
}

