/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSummary
implements ToCopyableBuilder<Builder, StackSummary> {
    private final String stackId;
    private final String stackName;
    private final String templateDescription;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final Instant deletionTime;
    private final String stackStatus;
    private final String stackStatusReason;
    private final String parentId;
    private final String rootId;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.templateDescription = builder.templateDescription;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.parentId = builder.parentId;
        this.rootId = builder.rootId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateDescription() {
        return this.templateDescription;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Instant deletionTime() {
        return this.deletionTime;
    }

    public StackStatus stackStatus() {
        return StackStatus.fromValue(this.stackStatus);
    }

    public String stackStatusAsString() {
        return this.stackStatus;
    }

    public String stackStatusReason() {
        return this.stackStatusReason;
    }

    public String parentId() {
        return this.parentId;
    }

    public String rootId() {
        return this.rootId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.deletionTime(), other.deletionTime()) && Objects.equals(this.stackStatusAsString(), other.stackStatusAsString()) && Objects.equals(this.stackStatusReason(), other.stackStatusReason()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.rootId(), other.rootId());
    }

    public String toString() {
        return ToString.builder((String)"StackSummary").add("StackId", (Object)this.stackId()).add("StackName", (Object)this.stackName()).add("TemplateDescription", (Object)this.templateDescription()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("DeletionTime", (Object)this.deletionTime()).add("StackStatus", (Object)this.stackStatusAsString()).add("StackStatusReason", (Object)this.stackStatusReason()).add("ParentId", (Object)this.parentId()).add("RootId", (Object)this.rootId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "TemplateDescription": {
                return Optional.of(clazz.cast(this.templateDescription()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.of(clazz.cast(this.lastUpdatedTime()));
            }
            case "DeletionTime": {
                return Optional.of(clazz.cast(this.deletionTime()));
            }
            case "StackStatus": {
                return Optional.of(clazz.cast(this.stackStatusAsString()));
            }
            case "StackStatusReason": {
                return Optional.of(clazz.cast(this.stackStatusReason()));
            }
            case "ParentId": {
                return Optional.of(clazz.cast(this.parentId()));
            }
            case "RootId": {
                return Optional.of(clazz.cast(this.rootId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String templateDescription;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private Instant deletionTime;
        private String stackStatus;
        private String stackStatusReason;
        private String parentId;
        private String rootId;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.templateDescription(model.templateDescription);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.deletionTime(model.deletionTime);
            this.stackStatus(model.stackStatus);
            this.stackStatusReason(model.stackStatusReason);
            this.parentId(model.parentId);
            this.rootId(model.rootId);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Instant getDeletionTime() {
            return this.deletionTime;
        }

        @Override
        public final Builder deletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final void setDeletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
        }

        public final String getStackStatus() {
            return this.stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final String getStackStatusReason() {
            return this.stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getRootId() {
            return this.rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public StackSummary build() {
            return new StackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSummary> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder templateDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder deletionTime(Instant var1);

        public Builder stackStatus(String var1);

        public Builder stackStatus(StackStatus var1);

        public Builder stackStatusReason(String var1);

        public Builder parentId(String var1);

        public Builder rootId(String var1);
    }
}

