/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.Stack;

public class DescribeStacksIterable
implements SdkIterable<DescribeStacksResponse> {
    private final CloudFormationClient client;
    private final DescribeStacksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStacksIterable(CloudFormationClient client, DescribeStacksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStacksResponseFetcher();
    }

    public Iterator<DescribeStacksResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Stack> stacks() {
        Function<DescribeStacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.stacks() != null) {
                return response.stacks().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeStacksIterable resume(DescribeStacksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeStacksIterable(this.client, (DescribeStacksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeStacksIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeStacksResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeStacksResponseFetcher
    implements SyncPageFetcher<DescribeStacksResponse> {
        private DescribeStacksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStacksResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeStacksResponse nextPage(DescribeStacksResponse previousPage) {
            if (previousPage == null) {
                return DescribeStacksIterable.this.client.describeStacks(DescribeStacksIterable.this.firstRequest);
            }
            return DescribeStacksIterable.this.client.describeStacks((DescribeStacksRequest)((Object)DescribeStacksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

