/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AccountLimit data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLimit implements ToCopyableBuilder<AccountLimit.Builder, AccountLimit> {
    private final String name;

    private final Integer value;

    private AccountLimit(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the account limit. Currently, the only account limit is <code>StackLimit</code>.
     * </p>
     * 
     * @return The name of the account limit. Currently, the only account limit is <code>StackLimit</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value that is associated with the account limit name.
     * </p>
     * 
     * @return The value that is associated with the account limit name.
     */
    public Integer value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLimit)) {
            return false;
        }
        AccountLimit other = (AccountLimit) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("AccountLimit").add("Name", name()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AccountLimit> {
        /**
         * <p>
         * The name of the account limit. Currently, the only account limit is <code>StackLimit</code>.
         * </p>
         * 
         * @param name
         *        The name of the account limit. Currently, the only account limit is <code>StackLimit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value that is associated with the account limit name.
         * </p>
         * 
         * @param value
         *        The value that is associated with the account limit name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer value;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLimit model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getValue() {
            return value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public AccountLimit build() {
            return new AccountLimit(this);
        }
    }
}
