/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Change</code> structure describes the changes AWS CloudFormation will perform if you execute the change
 * set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Change implements ToCopyableBuilder<Change.Builder, Change> {
    private final String type;

    private final ResourceChange resourceChange;

    private Change(BuilderImpl builder) {
        this.type = builder.type;
        this.resourceChange = builder.resourceChange;
    }

    /**
     * <p>
     * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of entity that AWS CloudFormation changes. Currently, the only entity type is
     *         <code>Resource</code>.
     * @see ChangeType
     */
    public ChangeType type() {
        return ChangeType.fromValue(type);
    }

    /**
     * <p>
     * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of entity that AWS CloudFormation changes. Currently, the only entity type is
     *         <code>Resource</code>.
     * @see ChangeType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will
     * perform.
     * </p>
     * 
     * @return A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation
     *         will perform.
     */
    public ResourceChange resourceChange() {
        return resourceChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceChange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resourceChange(), other.resourceChange());
    }

    @Override
    public String toString() {
        return ToString.builder("Change").add("Type", typeAsString()).add("ResourceChange", resourceChange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResourceChange":
            return Optional.ofNullable(clazz.cast(resourceChange()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
         * </p>
         * 
         * @param type
         *        The type of entity that AWS CloudFormation changes. Currently, the only entity type is
         *        <code>Resource</code>.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
         * </p>
         * 
         * @param type
         *        The type of entity that AWS CloudFormation changes. Currently, the only entity type is
         *        <code>Resource</code>.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(ChangeType type);

        /**
         * <p>
         * A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will
         * perform.
         * </p>
         * 
         * @param resourceChange
         *        A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation
         *        will perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceChange(ResourceChange resourceChange);

        /**
         * <p>
         * A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will
         * perform.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceChange.Builder} avoiding the need to
         * create one manually via {@link ResourceChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceChange.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceChange(ResourceChange)}.
         * 
         * @param resourceChange
         *        a consumer that will call methods on {@link ResourceChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceChange(ResourceChange)
         */
        default Builder resourceChange(Consumer<ResourceChange.Builder> resourceChange) {
            return resourceChange(ResourceChange.builder().applyMutation(resourceChange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private ResourceChange resourceChange;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            type(model.type);
            resourceChange(model.resourceChange);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ResourceChange.Builder getResourceChange() {
            return resourceChange != null ? resourceChange.toBuilder() : null;
        }

        @Override
        public final Builder resourceChange(ResourceChange resourceChange) {
            this.resourceChange = resourceChange;
            return this;
        }

        public final void setResourceChange(ResourceChange.BuilderImpl resourceChange) {
            this.resourceChange = resourceChange != null ? resourceChange.build() : null;
        }

        @Override
        public Change build() {
            return new Change(this);
        }
    }
}
