/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Export</code> structure describes the exported output values for a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Export implements ToCopyableBuilder<Export.Builder, Export> {
    private final String exportingStackId;

    private final String name;

    private final String value;

    private Export(BuilderImpl builder) {
        this.exportingStackId = builder.exportingStackId;
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The stack that contains the exported output name and value.
     * </p>
     * 
     * @return The stack that contains the exported output name and value.
     */
    public String exportingStackId() {
        return exportingStackId;
    }

    /**
     * <p>
     * The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the
     * associated value into other stacks. The name is defined in the <code>Export</code> field in the associated
     * stack's <code>Outputs</code> section.
     * </p>
     * 
     * @return The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import
     *         the associated value into other stacks. The name is defined in the <code>Export</code> field in the
     *         associated stack's <code>Outputs</code> section.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the exported output, such as a resource physical ID. This value is defined in the
     * <code>Export</code> field in the associated stack's <code>Outputs</code> section.
     * </p>
     * 
     * @return The value of the exported output, such as a resource physical ID. This value is defined in the
     *         <code>Export</code> field in the associated stack's <code>Outputs</code> section.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportingStackId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export) obj;
        return Objects.equals(exportingStackId(), other.exportingStackId()) && Objects.equals(name(), other.name())
                && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("Export").add("ExportingStackId", exportingStackId()).add("Name", name()).add("Value", value())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportingStackId":
            return Optional.ofNullable(clazz.cast(exportingStackId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Export> {
        /**
         * <p>
         * The stack that contains the exported output name and value.
         * </p>
         * 
         * @param exportingStackId
         *        The stack that contains the exported output name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportingStackId(String exportingStackId);

        /**
         * <p>
         * The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the
         * associated value into other stacks. The name is defined in the <code>Export</code> field in the associated
         * stack's <code>Outputs</code> section.
         * </p>
         * 
         * @param name
         *        The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to
         *        import the associated value into other stacks. The name is defined in the <code>Export</code> field in
         *        the associated stack's <code>Outputs</code> section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the exported output, such as a resource physical ID. This value is defined in the
         * <code>Export</code> field in the associated stack's <code>Outputs</code> section.
         * </p>
         * 
         * @param value
         *        The value of the exported output, such as a resource physical ID. This value is defined in the
         *        <code>Export</code> field in the associated stack's <code>Outputs</code> section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String exportingStackId;

        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Export model) {
            exportingStackId(model.exportingStackId);
            name(model.name);
            value(model.value);
        }

        public final String getExportingStackId() {
            return exportingStackId;
        }

        @Override
        public final Builder exportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
            return this;
        }

        public final void setExportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Export build() {
            return new Export(this);
        }
    }
}
