/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackSetOperationsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackSetOperationsResponse.Builder, ListStackSetOperationsResponse> {
    private final List<StackSetOperationSummary> summaries;

    private final String nextToken;

    private ListStackSetOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>StackSetOperationSummary</code> structures that contain summary information about operations for
     * the specified stack set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackSetOperationSummary</code> structures that contain summary information about
     *         operations for the specified stack set.
     */
    public List<StackSetOperationSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next set of
     * results, call <code>ListOperationResults</code> again and assign that token to the request object's
     * <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next
     *         set of results, call <code>ListOperationResults</code> again and assign that token to the request
     *         object's <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is
     *         set to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationsResponse)) {
            return false;
        }
        ListStackSetOperationsResponse other = (ListStackSetOperationsResponse) obj;
        return Objects.equals(summaries(), other.summaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListStackSetOperationsResponse").add("Summaries", summaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, ListStackSetOperationsResponse> {
        /**
         * <p>
         * A list of <code>StackSetOperationSummary</code> structures that contain summary information about operations
         * for the specified stack set.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetOperationSummary</code> structures that contain summary information about
         *        operations for the specified stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<StackSetOperationSummary> summaries);

        /**
         * <p>
         * A list of <code>StackSetOperationSummary</code> structures that contain summary information about operations
         * for the specified stack set.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetOperationSummary</code> structures that contain summary information about
         *        operations for the specified stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(StackSetOperationSummary... summaries);

        /**
         * <p>
         * A list of <code>StackSetOperationSummary</code> structures that contain summary information about operations
         * for the specified stack set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackSetOperationSummary>.Builder} avoiding
         * the need to create one manually via {@link List<StackSetOperationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackSetOperationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #summaries(List<StackSetOperationSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<StackSetOperationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<StackSetOperationSummary>)
         */
        Builder summaries(Consumer<StackSetOperationSummary.Builder>... summaries);

        /**
         * <p>
         * If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next set
         * of results, call <code>ListOperationResults</code> again and assign that token to the request object's
         * <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the
         *        next set of results, call <code>ListOperationResults</code> again and assign that token to the request
         *        object's <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code>
         *        is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackSetOperationSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationsResponse model) {
            super(model);
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final Collection<StackSetOperationSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(StackSetOperationSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetOperationSummary> summaries) {
            this.summaries = StackSetOperationSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetOperationSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<StackSetOperationSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> StackSetOperationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<StackSetOperationSummary.BuilderImpl> summaries) {
            this.summaries = StackSetOperationSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackSetOperationsResponse build() {
            return new ListStackSetOperationsResponse(this);
        }
    }
}
