/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The TemplateParameter data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateParameter implements ToCopyableBuilder<TemplateParameter.Builder, TemplateParameter> {
    private final String parameterKey;

    private final String defaultValue;

    private final Boolean noEcho;

    private final String description;

    private TemplateParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name associated with the parameter.
     * </p>
     * 
     * @return The name associated with the parameter.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The default value associated with the parameter.
     * </p>
     * 
     * @return The default value associated with the parameter.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
     * </p>
     * 
     * @return Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
     */
    public Boolean noEcho() {
        return noEcho;
    }

    /**
     * <p>
     * User defined description associated with the parameter.
     * </p>
     * 
     * @return User defined description associated with the parameter.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameter)) {
            return false;
        }
        TemplateParameter other = (TemplateParameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(noEcho(), other.noEcho()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("TemplateParameter").add("ParameterKey", parameterKey()).add("DefaultValue", defaultValue())
                .add("NoEcho", noEcho()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "NoEcho":
            return Optional.ofNullable(clazz.cast(noEcho()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TemplateParameter> {
        /**
         * <p>
         * The name associated with the parameter.
         * </p>
         * 
         * @param parameterKey
         *        The name associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The default value associated with the parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
         * </p>
         * 
         * @param noEcho
         *        Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noEcho(Boolean noEcho);

        /**
         * <p>
         * User defined description associated with the parameter.
         * </p>
         * 
         * @param description
         *        User defined description associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String defaultValue;

        private Boolean noEcho;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameter model) {
            parameterKey(model.parameterKey);
            defaultValue(model.defaultValue);
            noEcho(model.noEcho);
            description(model.description);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final Boolean getNoEcho() {
            return noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public TemplateParameter build() {
            return new TemplateParameter(this);
        }
    }
}
