/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for an <a>UpdateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStackResponse extends CloudFormationResponse implements
        ToCopyableBuilder<UpdateStackResponse.Builder, UpdateStackResponse> {
    private final String stackId;

    private UpdateStackResponse(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackResponse)) {
            return false;
        }
        UpdateStackResponse other = (UpdateStackResponse) obj;
        return Objects.equals(stackId(), other.stackId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateStackResponse").add("StackId", stackId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, UpdateStackResponse> {
        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackResponse model) {
            super(model);
            stackId(model.stackId);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public UpdateStackResponse build() {
            return new UpdateStackResponse(this);
        }
    }
}
