/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateChangeSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateChangeSetRequestMarshaller implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {

    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {

        if (createChangeSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateChangeSetRequest> request = new DefaultRequest<CreateChangeSetRequest>(createChangeSetRequest,
                "CloudFormationClient");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString(createChangeSetRequest.stackName()));
        }

        if (createChangeSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString(createChangeSetRequest.templateBody()));
        }

        if (createChangeSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString(createChangeSetRequest.templateURL()));
        }

        if (createChangeSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate",
                    StringConversion.fromBoolean(createChangeSetRequest.usePreviousTemplate()));
        }

        if (createChangeSetRequest.parameters().isEmpty()
                && !(createChangeSetRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!createChangeSetRequest.parameters().isEmpty()
                && !(createChangeSetRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Parameter> parametersList = createChangeSetRequest.parameters();
            int parametersListIndex = 1;

            for (Parameter parametersListValue : parametersList) {

                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                            StringConversion.fromString(parametersListValue.parameterKey()));
                }

                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                            StringConversion.fromString(parametersListValue.parameterValue()));
                }

                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                            StringConversion.fromBoolean(parametersListValue.usePreviousValue()));
                }
                parametersListIndex++;
            }
        }

        if (createChangeSetRequest.capabilitiesAsStrings().isEmpty()
                && !(createChangeSetRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!createChangeSetRequest.capabilitiesAsStrings().isEmpty()
                && !(createChangeSetRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> capabilitiesList = createChangeSetRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;

            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex,
                            StringConversion.fromString(capabilitiesListValue));
                }
                capabilitiesListIndex++;
            }
        }

        if (createChangeSetRequest.resourceTypes().isEmpty()
                && !(createChangeSetRequest.resourceTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ResourceTypes", "");
        } else if (!createChangeSetRequest.resourceTypes().isEmpty()
                && !(createChangeSetRequest.resourceTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> resourceTypesList = createChangeSetRequest.resourceTypes();
            int resourceTypesListIndex = 1;

            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex,
                            StringConversion.fromString(resourceTypesListValue));
                }
                resourceTypesListIndex++;
            }
        }

        if (createChangeSetRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString(createChangeSetRequest.roleARN()));
        }

        RollbackConfiguration rollbackConfiguration = createChangeSetRequest.rollbackConfiguration();
        if (rollbackConfiguration != null) {

            if (rollbackConfiguration.rollbackTriggers().isEmpty()
                    && !(rollbackConfiguration.rollbackTriggers() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            } else if (!rollbackConfiguration.rollbackTriggers().isEmpty()
                    && !(rollbackConfiguration.rollbackTriggers() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
                int rollbackTriggersListIndex = 1;

                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {

                    if (rollbackTriggersListValue.arn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                + ".Arn", StringConversion.fromString(rollbackTriggersListValue.arn()));
                    }

                    if (rollbackTriggersListValue.type() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                + ".Type", StringConversion.fromString(rollbackTriggersListValue.type()));
                    }
                    rollbackTriggersListIndex++;
                }
            }

            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes",
                        StringConversion.fromInteger(rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }

        if (createChangeSetRequest.notificationARNs().isEmpty()
                && !(createChangeSetRequest.notificationARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("NotificationARNs", "");
        } else if (!createChangeSetRequest.notificationARNs().isEmpty()
                && !(createChangeSetRequest.notificationARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> notificationARNsList = createChangeSetRequest.notificationARNs();
            int notificationARNsListIndex = 1;

            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex,
                            StringConversion.fromString(notificationARNsListValue));
                }
                notificationARNsListIndex++;
            }
        }

        if (createChangeSetRequest.tags().isEmpty()
                && !(createChangeSetRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createChangeSetRequest.tags().isEmpty()
                && !(createChangeSetRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = createChangeSetRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (createChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringConversion.fromString(createChangeSetRequest.changeSetName()));
        }

        if (createChangeSetRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString(createChangeSetRequest.clientToken()));
        }

        if (createChangeSetRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString(createChangeSetRequest.description()));
        }

        if (createChangeSetRequest.changeSetTypeAsString() != null) {
            request.addParameter("ChangeSetType", StringConversion.fromString(createChangeSetRequest.changeSetTypeAsString()));
        }

        return request;
    }

}
