/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStackRequestMarshaller implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {

    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {

        if (createStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateStackRequest> request = new DefaultRequest<CreateStackRequest>(createStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString(createStackRequest.stackName()));
        }

        if (createStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString(createStackRequest.templateBody()));
        }

        if (createStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString(createStackRequest.templateURL()));
        }

        if (createStackRequest.parameters().isEmpty()
                && !(createStackRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!createStackRequest.parameters().isEmpty()
                && !(createStackRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Parameter> parametersList = createStackRequest.parameters();
            int parametersListIndex = 1;

            for (Parameter parametersListValue : parametersList) {

                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                            StringConversion.fromString(parametersListValue.parameterKey()));
                }

                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                            StringConversion.fromString(parametersListValue.parameterValue()));
                }

                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                            StringConversion.fromBoolean(parametersListValue.usePreviousValue()));
                }
                parametersListIndex++;
            }
        }

        if (createStackRequest.disableRollback() != null) {
            request.addParameter("DisableRollback", StringConversion.fromBoolean(createStackRequest.disableRollback()));
        }

        RollbackConfiguration rollbackConfiguration = createStackRequest.rollbackConfiguration();
        if (rollbackConfiguration != null) {

            if (rollbackConfiguration.rollbackTriggers().isEmpty()
                    && !(rollbackConfiguration.rollbackTriggers() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            } else if (!rollbackConfiguration.rollbackTriggers().isEmpty()
                    && !(rollbackConfiguration.rollbackTriggers() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
                int rollbackTriggersListIndex = 1;

                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {

                    if (rollbackTriggersListValue.arn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                + ".Arn", StringConversion.fromString(rollbackTriggersListValue.arn()));
                    }

                    if (rollbackTriggersListValue.type() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                + ".Type", StringConversion.fromString(rollbackTriggersListValue.type()));
                    }
                    rollbackTriggersListIndex++;
                }
            }

            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes",
                        StringConversion.fromInteger(rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }

        if (createStackRequest.timeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringConversion.fromInteger(createStackRequest.timeoutInMinutes()));
        }

        if (createStackRequest.notificationARNs().isEmpty()
                && !(createStackRequest.notificationARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("NotificationARNs", "");
        } else if (!createStackRequest.notificationARNs().isEmpty()
                && !(createStackRequest.notificationARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> notificationARNsList = createStackRequest.notificationARNs();
            int notificationARNsListIndex = 1;

            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex,
                            StringConversion.fromString(notificationARNsListValue));
                }
                notificationARNsListIndex++;
            }
        }

        if (createStackRequest.capabilitiesAsStrings().isEmpty()
                && !(createStackRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!createStackRequest.capabilitiesAsStrings().isEmpty()
                && !(createStackRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> capabilitiesList = createStackRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;

            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex,
                            StringConversion.fromString(capabilitiesListValue));
                }
                capabilitiesListIndex++;
            }
        }

        if (createStackRequest.resourceTypes().isEmpty()
                && !(createStackRequest.resourceTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ResourceTypes", "");
        } else if (!createStackRequest.resourceTypes().isEmpty()
                && !(createStackRequest.resourceTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> resourceTypesList = createStackRequest.resourceTypes();
            int resourceTypesListIndex = 1;

            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex,
                            StringConversion.fromString(resourceTypesListValue));
                }
                resourceTypesListIndex++;
            }
        }

        if (createStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString(createStackRequest.roleARN()));
        }

        if (createStackRequest.onFailureAsString() != null) {
            request.addParameter("OnFailure", StringConversion.fromString(createStackRequest.onFailureAsString()));
        }

        if (createStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringConversion.fromString(createStackRequest.stackPolicyBody()));
        }

        if (createStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringConversion.fromString(createStackRequest.stackPolicyURL()));
        }

        if (createStackRequest.tags().isEmpty()
                && !(createStackRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createStackRequest.tags().isEmpty()
                && !(createStackRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = createStackRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (createStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString(createStackRequest.clientRequestToken()));
        }

        if (createStackRequest.enableTerminationProtection() != null) {
            request.addParameter("EnableTerminationProtection",
                    StringConversion.fromBoolean(createStackRequest.enableTerminationProtection()));
        }

        return request;
    }

}
