/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * UpdateStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateStackRequestMarshaller implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {

    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {

        if (updateStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateStackRequest> request = new DefaultRequest<UpdateStackRequest>(updateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString(updateStackRequest.stackName()));
        }

        if (updateStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString(updateStackRequest.templateBody()));
        }

        if (updateStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString(updateStackRequest.templateURL()));
        }

        if (updateStackRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringConversion.fromBoolean(updateStackRequest.usePreviousTemplate()));
        }

        if (updateStackRequest.stackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody",
                    StringConversion.fromString(updateStackRequest.stackPolicyDuringUpdateBody()));
        }

        if (updateStackRequest.stackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL",
                    StringConversion.fromString(updateStackRequest.stackPolicyDuringUpdateURL()));
        }

        if (updateStackRequest.parameters().isEmpty()
                && !(updateStackRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!updateStackRequest.parameters().isEmpty()
                && !(updateStackRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Parameter> parametersList = updateStackRequest.parameters();
            int parametersListIndex = 1;

            for (Parameter parametersListValue : parametersList) {

                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                            StringConversion.fromString(parametersListValue.parameterKey()));
                }

                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                            StringConversion.fromString(parametersListValue.parameterValue()));
                }

                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                            StringConversion.fromBoolean(parametersListValue.usePreviousValue()));
                }
                parametersListIndex++;
            }
        }

        if (updateStackRequest.capabilitiesAsStrings().isEmpty()
                && !(updateStackRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!updateStackRequest.capabilitiesAsStrings().isEmpty()
                && !(updateStackRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> capabilitiesList = updateStackRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;

            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex,
                            StringConversion.fromString(capabilitiesListValue));
                }
                capabilitiesListIndex++;
            }
        }

        if (updateStackRequest.resourceTypes().isEmpty()
                && !(updateStackRequest.resourceTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ResourceTypes", "");
        } else if (!updateStackRequest.resourceTypes().isEmpty()
                && !(updateStackRequest.resourceTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> resourceTypesList = updateStackRequest.resourceTypes();
            int resourceTypesListIndex = 1;

            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex,
                            StringConversion.fromString(resourceTypesListValue));
                }
                resourceTypesListIndex++;
            }
        }

        if (updateStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString(updateStackRequest.roleARN()));
        }

        RollbackConfiguration rollbackConfiguration = updateStackRequest.rollbackConfiguration();
        if (rollbackConfiguration != null) {

            if (rollbackConfiguration.rollbackTriggers().isEmpty()
                    && !(rollbackConfiguration.rollbackTriggers() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            } else if (!rollbackConfiguration.rollbackTriggers().isEmpty()
                    && !(rollbackConfiguration.rollbackTriggers() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
                int rollbackTriggersListIndex = 1;

                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {

                    if (rollbackTriggersListValue.arn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                + ".Arn", StringConversion.fromString(rollbackTriggersListValue.arn()));
                    }

                    if (rollbackTriggersListValue.type() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                + ".Type", StringConversion.fromString(rollbackTriggersListValue.type()));
                    }
                    rollbackTriggersListIndex++;
                }
            }

            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes",
                        StringConversion.fromInteger(rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }

        if (updateStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringConversion.fromString(updateStackRequest.stackPolicyBody()));
        }

        if (updateStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringConversion.fromString(updateStackRequest.stackPolicyURL()));
        }

        if (updateStackRequest.notificationARNs().isEmpty()
                && !(updateStackRequest.notificationARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("NotificationARNs", "");
        } else if (!updateStackRequest.notificationARNs().isEmpty()
                && !(updateStackRequest.notificationARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> notificationARNsList = updateStackRequest.notificationARNs();
            int notificationARNsListIndex = 1;

            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex,
                            StringConversion.fromString(notificationARNsListValue));
                }
                notificationARNsListIndex++;
            }
        }

        if (updateStackRequest.tags().isEmpty()
                && !(updateStackRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!updateStackRequest.tags().isEmpty()
                && !(updateStackRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = updateStackRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (updateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString(updateStackRequest.clientRequestToken()));
        }

        return request;
    }

}
