/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackResourcesResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackResourcesResponse> {
    private final List<StackResourceSummary> stackResourceSummaries;
    private final String nextToken;

    private ListStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceSummaries = builder.stackResourceSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackResourceSummary> stackResourceSummaries() {
        return this.stackResourceSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackResourceSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResponse)) {
            return false;
        }
        ListStackResourcesResponse other = (ListStackResourcesResponse)((Object)obj);
        return Objects.equals(this.stackResourceSummaries(), other.stackResourceSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStackResourcesResponse").add("StackResourceSummaries", this.stackResourceSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResourceSummaries": {
                return Optional.ofNullable(clazz.cast(this.stackResourceSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackResourceSummary> stackResourceSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackResourcesResponse model) {
            super(model);
            this.stackResourceSummaries(model.stackResourceSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackResourceSummary.Builder> getStackResourceSummaries() {
            return this.stackResourceSummaries != null ? (Collection)this.stackResourceSummaries.stream().map(StackResourceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copy(stackResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(StackResourceSummary ... stackResourceSummaries) {
            this.stackResourceSummaries(Arrays.asList(stackResourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(Consumer<StackResourceSummary.Builder> ... stackResourceSummaries) {
            this.stackResourceSummaries(Stream.of(stackResourceSummaries).map(c -> (StackResourceSummary)((StackResourceSummary.Builder)StackResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStackResourceSummaries(Collection<StackResourceSummary.BuilderImpl> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copyFromBuilder(stackResourceSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackResourcesResponse build() {
            return new ListStackResourcesResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, ListStackResourcesResponse> {
        public Builder stackResourceSummaries(Collection<StackResourceSummary> var1);

        public Builder stackResourceSummaries(StackResourceSummary ... var1);

        public Builder stackResourceSummaries(Consumer<StackResourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

