/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.Export;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;

public class ListExportsIterable
implements SdkIterable<ListExportsResponse> {
    private final CloudFormationClient client;
    private final ListExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportsIterable(CloudFormationClient client, ListExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public Iterator<ListExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Export> exports() {
        Function<ListExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exports() != null) {
                return response.exports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListExportsIterable resume(ListExportsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListExportsIterable(this.client, (ListExportsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListExportsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListExportsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListExportsResponseFetcher
    implements SyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListExportsResponse nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsIterable.this.client.listExports(ListExportsIterable.this.firstRequest);
            }
            return ListExportsIterable.this.client.listExports((ListExportsRequest)((Object)ListExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

