/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;

public class DeleteChangeSetRequestMarshaller
implements Marshaller<Request<DeleteChangeSetRequest>, DeleteChangeSetRequest> {
    public Request<DeleteChangeSetRequest> marshall(DeleteChangeSetRequest deleteChangeSetRequest) {
        if (deleteChangeSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringConversion.fromString((String)deleteChangeSetRequest.changeSetName()));
        }
        if (deleteChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)deleteChangeSetRequest.stackName()));
        }
        return request;
    }
}

