/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;

public class DescribeStackInstanceRequestMarshaller
implements Marshaller<Request<DescribeStackInstanceRequest>, DescribeStackInstanceRequest> {
    public Request<DescribeStackInstanceRequest> marshall(DescribeStackInstanceRequest describeStackInstanceRequest) {
        if (describeStackInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeStackInstanceRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackInstance");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackInstanceRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)describeStackInstanceRequest.stackSetName()));
        }
        if (describeStackInstanceRequest.stackInstanceAccount() != null) {
            request.addParameter("StackInstanceAccount", StringConversion.fromString((String)describeStackInstanceRequest.stackInstanceAccount()));
        }
        if (describeStackInstanceRequest.stackInstanceRegion() != null) {
            request.addParameter("StackInstanceRegion", StringConversion.fromString((String)describeStackInstanceRequest.stackInstanceRegion()));
        }
        return request;
    }
}

