/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;

public class ListStacksRequestMarshaller
implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {
    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {
        if (listStacksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listStacksRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStacksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listStacksRequest.nextToken()));
        }
        if (listStacksRequest.stackStatusFiltersAsStrings().isEmpty() && !(listStacksRequest.stackStatusFiltersAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("StackStatusFilter", "");
        } else if (!listStacksRequest.stackStatusFiltersAsStrings().isEmpty() && !(listStacksRequest.stackStatusFiltersAsStrings() instanceof SdkAutoConstructList)) {
            List<String> stackStatusFiltersList = listStacksRequest.stackStatusFiltersAsStrings();
            int stackStatusFiltersListIndex = 1;
            for (String stackStatusFiltersListValue : stackStatusFiltersList) {
                if (stackStatusFiltersListValue != null) {
                    request.addParameter("StackStatusFilter.member." + stackStatusFiltersListIndex, StringConversion.fromString((String)stackStatusFiltersListValue));
                }
                ++stackStatusFiltersListIndex;
            }
        }
        return request;
    }
}

