/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Parameter data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameter implements ToCopyableBuilder<Parameter.Builder, Parameter> {
    private final String parameterKey;

    private final String parameterValue;

    private final Boolean usePreviousValue;

    private final String resolvedValue;

    private Parameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
        this.usePreviousValue = builder.usePreviousValue;
        this.resolvedValue = builder.resolvedValue;
    }

    /**
     * <p>
     * The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS
     * CloudFormation uses the default value that is specified in your template.
     * </p>
     * 
     * @return The key associated with the parameter. If you don't specify a key and value for a particular parameter,
     *         AWS CloudFormation uses the default value that is specified in your template.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The input value associated with the parameter.
     * </p>
     * 
     * @return The input value associated with the parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    /**
     * <p>
     * During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you
     * specify <code>true</code>, do not specify a parameter value.
     * </p>
     * 
     * @return During a stack update, use the existing parameter value that the stack is using for a given parameter
     *         key. If you specify <code>true</code>, do not specify a parameter value.
     */
    public Boolean usePreviousValue() {
        return usePreviousValue;
    }

    /**
     * <p>
     * Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for <a
     * href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"
     * > <code>SSM</code> parameter types</a> in the template.
     * </p>
     * 
     * @return Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"
     *         > <code>SSM</code> parameter types</a> in the template.
     */
    public String resolvedValue() {
        return resolvedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousValue());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(parameterValue(), other.parameterValue())
                && Objects.equals(usePreviousValue(), other.usePreviousValue())
                && Objects.equals(resolvedValue(), other.resolvedValue());
    }

    @Override
    public String toString() {
        return ToString.builder("Parameter").add("ParameterKey", parameterKey()).add("ParameterValue", parameterValue())
                .add("UsePreviousValue", usePreviousValue()).add("ResolvedValue", resolvedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        case "UsePreviousValue":
            return Optional.ofNullable(clazz.cast(usePreviousValue()));
        case "ResolvedValue":
            return Optional.ofNullable(clazz.cast(resolvedValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Parameter> {
        /**
         * <p>
         * The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS
         * CloudFormation uses the default value that is specified in your template.
         * </p>
         * 
         * @param parameterKey
         *        The key associated with the parameter. If you don't specify a key and value for a particular
         *        parameter, AWS CloudFormation uses the default value that is specified in your template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The input value associated with the parameter.
         * </p>
         * 
         * @param parameterValue
         *        The input value associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);

        /**
         * <p>
         * During a stack update, use the existing parameter value that the stack is using for a given parameter key. If
         * you specify <code>true</code>, do not specify a parameter value.
         * </p>
         * 
         * @param usePreviousValue
         *        During a stack update, use the existing parameter value that the stack is using for a given parameter
         *        key. If you specify <code>true</code>, do not specify a parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousValue(Boolean usePreviousValue);

        /**
         * <p>
         * Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for <a
         * href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"
         * > <code>SSM</code> parameter types</a> in the template.
         * </p>
         * 
         * @param resolvedValue
         *        Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only
         *        for <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"
         *        > <code>SSM</code> parameter types</a> in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedValue(String resolvedValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String parameterValue;

        private Boolean usePreviousValue;

        private String resolvedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            parameterKey(model.parameterKey);
            parameterValue(model.parameterValue);
            usePreviousValue(model.usePreviousValue);
            resolvedValue(model.resolvedValue);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Boolean getUsePreviousValue() {
            return usePreviousValue;
        }

        @Override
        public final Builder usePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
            return this;
        }

        public final void setUsePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
        }

        public final String getResolvedValue() {
            return resolvedValue;
        }

        @Override
        public final Builder resolvedValue(String resolvedValue) {
            this.resolvedValue = resolvedValue;
            return this;
        }

        public final void setResolvedValue(String resolvedValue) {
            this.resolvedValue = resolvedValue;
        }

        @Override
        public Parameter build() {
            return new Parameter(this);
        }
    }
}
