/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of criteria that AWS CloudFormation uses to validate parameter values. Although other constraints might be
 * defined in the stack template, AWS CloudFormation returns only the <code>AllowedValues</code> property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterConstraints implements ToCopyableBuilder<ParameterConstraints.Builder, ParameterConstraints> {
    private final List<String> allowedValues;

    private ParameterConstraints(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
    }

    /**
     * <p>
     * A list of values that are permitted for a parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of values that are permitted for a parameter.
     */
    public List<String> allowedValues() {
        return allowedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints) obj;
        return Objects.equals(allowedValues(), other.allowedValues());
    }

    @Override
    public String toString() {
        return ToString.builder("ParameterConstraints").add("AllowedValues", allowedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ParameterConstraints> {
        /**
         * <p>
         * A list of values that are permitted for a parameter.
         * </p>
         * 
         * @param allowedValues
         *        A list of values that are permitted for a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * A list of values that are permitted for a parameter.
         * </p>
         * 
         * @param allowedValues
         *        A list of values that are permitted for a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            allowedValues(model.allowedValues);
        }

        public final Collection<String> getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        @Override
        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }
    }
}
