/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>ValidateTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateTemplateResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ValidateTemplateResponse.Builder, ValidateTemplateResponse> {
    private final List<TemplateParameter> parameters;

    private final String description;

    private final List<String> capabilities;

    private final String capabilitiesReason;

    private final List<String> declaredTransforms;

    private ValidateTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.declaredTransforms = builder.declaredTransforms;
    }

    /**
     * <p>
     * A list of <code>TemplateParameter</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>TemplateParameter</code> structures.
     */
    public List<TemplateParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The description found within the template.
     * </p>
     * 
     * @return The description found within the template.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     *         <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     *         InsufficientCapabilities error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<Capability> capabilities() {
        return TypeConverter.convert(capabilities, Capability::fromValue);
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     *         <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     *         InsufficientCapabilities error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The list of resources that generated the values in the <code>Capabilities</code> response element.
     * </p>
     * 
     * @return The list of resources that generated the values in the <code>Capabilities</code> response element.
     */
    public String capabilitiesReason() {
        return capabilitiesReason;
    }

    /**
     * <p>
     * A list of the transforms that are declared in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the transforms that are declared in the template.
     */
    public List<String> declaredTransforms() {
        return declaredTransforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesReason());
        hashCode = 31 * hashCode + Objects.hashCode(declaredTransforms());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateResponse)) {
            return false;
        }
        ValidateTemplateResponse other = (ValidateTemplateResponse) obj;
        return Objects.equals(parameters(), other.parameters()) && Objects.equals(description(), other.description())
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(capabilitiesReason(), other.capabilitiesReason())
                && Objects.equals(declaredTransforms(), other.declaredTransforms());
    }

    @Override
    public String toString() {
        return ToString.builder("ValidateTemplateResponse").add("Parameters", parameters()).add("Description", description())
                .add("Capabilities", capabilitiesAsStrings()).add("CapabilitiesReason", capabilitiesReason())
                .add("DeclaredTransforms", declaredTransforms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "CapabilitiesReason":
            return Optional.ofNullable(clazz.cast(capabilitiesReason()));
        case "DeclaredTransforms":
            return Optional.ofNullable(clazz.cast(declaredTransforms()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, ValidateTemplateResponse> {
        /**
         * <p>
         * A list of <code>TemplateParameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>TemplateParameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<TemplateParameter> parameters);

        /**
         * <p>
         * A list of <code>TemplateParameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>TemplateParameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(TemplateParameter... parameters);

        /**
         * <p>
         * A list of <code>TemplateParameter</code> structures.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateParameter>.Builder} avoiding the
         * need to create one manually via {@link List<TemplateParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<TemplateParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<TemplateParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<TemplateParameter>)
         */
        Builder parameters(Consumer<TemplateParameter.Builder>... parameters);

        /**
         * <p>
         * The description found within the template.
         * </p>
         * 
         * @param description
         *        The description found within the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The list of resources that generated the values in the <code>Capabilities</code> response element.
         * </p>
         * 
         * @param capabilitiesReason
         *        The list of resources that generated the values in the <code>Capabilities</code> response element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesReason(String capabilitiesReason);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(Collection<String> declaredTransforms);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(String... declaredTransforms);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<TemplateParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String capabilitiesReason;

        private List<String> declaredTransforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTemplateResponse model) {
            super(model);
            parameters(model.parameters);
            description(model.description);
            capabilitiesWithStrings(model.capabilities);
            capabilitiesReason(model.capabilitiesReason);
            declaredTransforms(model.declaredTransforms);
        }

        public final Collection<TemplateParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(TemplateParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<TemplateParameter> parameters) {
            this.parameters = TemplateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TemplateParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<TemplateParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> TemplateParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<TemplateParameter.BuilderImpl> parameters) {
            this.parameters = TemplateParametersCopier.copyFromBuilder(parameters);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final String getCapabilitiesReason() {
            return capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getDeclaredTransforms() {
            return declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String... declaredTransforms) {
            declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public ValidateTemplateResponse build() {
            return new ValidateTemplateResponse(this);
        }
    }
}
