/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * CreateStackSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStackSetRequestMarshaller implements Marshaller<Request<CreateStackSetRequest>, CreateStackSetRequest> {

    public Request<CreateStackSetRequest> marshall(CreateStackSetRequest createStackSetRequest) {

        if (createStackSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateStackSetRequest> request = new DefaultRequest<CreateStackSetRequest>(createStackSetRequest,
                "CloudFormationClient");
        request.addParameter("Action", "CreateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString(createStackSetRequest.stackSetName()));
        }

        if (createStackSetRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString(createStackSetRequest.description()));
        }

        if (createStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString(createStackSetRequest.templateBody()));
        }

        if (createStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString(createStackSetRequest.templateURL()));
        }

        if (createStackSetRequest.parameters().isEmpty()
                && !(createStackSetRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!createStackSetRequest.parameters().isEmpty()
                && !(createStackSetRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Parameter> parametersList = createStackSetRequest.parameters();
            int parametersListIndex = 1;

            for (Parameter parametersListValue : parametersList) {

                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                            StringConversion.fromString(parametersListValue.parameterKey()));
                }

                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                            StringConversion.fromString(parametersListValue.parameterValue()));
                }

                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                            StringConversion.fromBoolean(parametersListValue.usePreviousValue()));
                }

                if (parametersListValue.resolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue",
                            StringConversion.fromString(parametersListValue.resolvedValue()));
                }
                parametersListIndex++;
            }
        }

        if (createStackSetRequest.capabilitiesAsStrings().isEmpty()
                && !(createStackSetRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!createStackSetRequest.capabilitiesAsStrings().isEmpty()
                && !(createStackSetRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> capabilitiesList = createStackSetRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;

            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex,
                            StringConversion.fromString(capabilitiesListValue));
                }
                capabilitiesListIndex++;
            }
        }

        if (createStackSetRequest.tags().isEmpty()
                && !(createStackSetRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createStackSetRequest.tags().isEmpty()
                && !(createStackSetRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = createStackSetRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (createStackSetRequest.administrationRoleARN() != null) {
            request.addParameter("AdministrationRoleARN",
                    StringConversion.fromString(createStackSetRequest.administrationRoleARN()));
        }

        if (createStackSetRequest.executionRoleName() != null) {
            request.addParameter("ExecutionRoleName", StringConversion.fromString(createStackSetRequest.executionRoleName()));
        }

        request.addParameter("ClientRequestToken", IdempotentUtils.resolveString(createStackSetRequest.clientRequestToken()));

        return request;
    }

}
