/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * DeleteStackInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteStackInstancesRequestMarshaller implements
        Marshaller<Request<DeleteStackInstancesRequest>, DeleteStackInstancesRequest> {

    public Request<DeleteStackInstancesRequest> marshall(DeleteStackInstancesRequest deleteStackInstancesRequest) {

        if (deleteStackInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DeleteStackInstancesRequest> request = new DefaultRequest<DeleteStackInstancesRequest>(
                deleteStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (deleteStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString(deleteStackInstancesRequest.stackSetName()));
        }

        if (deleteStackInstancesRequest.accounts().isEmpty()
                && !(deleteStackInstancesRequest.accounts() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Accounts", "");
        } else if (!deleteStackInstancesRequest.accounts().isEmpty()
                && !(deleteStackInstancesRequest.accounts() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> accountsList = deleteStackInstancesRequest.accounts();
            int accountsListIndex = 1;

            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringConversion.fromString(accountsListValue));
                }
                accountsListIndex++;
            }
        }

        if (deleteStackInstancesRequest.regions().isEmpty()
                && !(deleteStackInstancesRequest.regions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Regions", "");
        } else if (!deleteStackInstancesRequest.regions().isEmpty()
                && !(deleteStackInstancesRequest.regions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> regionsList = deleteStackInstancesRequest.regions();
            int regionsListIndex = 1;

            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringConversion.fromString(regionsListValue));
                }
                regionsListIndex++;
            }
        }

        StackSetOperationPreferences operationPreferences = deleteStackInstancesRequest.operationPreferences();
        if (operationPreferences != null) {

            if (operationPreferences.regionOrder().isEmpty()
                    && !(operationPreferences.regionOrder() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            } else if (!operationPreferences.regionOrder().isEmpty()
                    && !(operationPreferences.regionOrder() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> regionOrderList = operationPreferences.regionOrder();
                int regionOrderListIndex = 1;

                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex,
                                StringConversion.fromString(regionOrderListValue));
                    }
                    regionOrderListIndex++;
                }
            }

            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount",
                        StringConversion.fromInteger(operationPreferences.failureToleranceCount()));
            }

            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage",
                        StringConversion.fromInteger(operationPreferences.failureTolerancePercentage()));
            }

            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount",
                        StringConversion.fromInteger(operationPreferences.maxConcurrentCount()));
            }

            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage",
                        StringConversion.fromInteger(operationPreferences.maxConcurrentPercentage()));
            }
        }

        if (deleteStackInstancesRequest.retainStacks() != null) {
            request.addParameter("RetainStacks", StringConversion.fromBoolean(deleteStackInstancesRequest.retainStacks()));
        }

        request.addParameter("OperationId", IdempotentUtils.resolveString(deleteStackInstancesRequest.operationId()));

        return request;
    }

}
