/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * ListStackInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListStackInstancesRequestMarshaller implements
        Marshaller<Request<ListStackInstancesRequest>, ListStackInstancesRequest> {

    public Request<ListStackInstancesRequest> marshall(ListStackInstancesRequest listStackInstancesRequest) {

        if (listStackInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<ListStackInstancesRequest> request = new DefaultRequest<ListStackInstancesRequest>(listStackInstancesRequest,
                "CloudFormationClient");
        request.addParameter("Action", "ListStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (listStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString(listStackInstancesRequest.stackSetName()));
        }

        if (listStackInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString(listStackInstancesRequest.nextToken()));
        }

        if (listStackInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger(listStackInstancesRequest.maxResults()));
        }

        if (listStackInstancesRequest.stackInstanceAccount() != null) {
            request.addParameter("StackInstanceAccount",
                    StringConversion.fromString(listStackInstancesRequest.stackInstanceAccount()));
        }

        if (listStackInstancesRequest.stackInstanceRegion() != null) {
            request.addParameter("StackInstanceRegion",
                    StringConversion.fromString(listStackInstancesRequest.stackInstanceRegion()));
        }

        return request;
    }

}
